/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.igss.utility;

import edu.udo.cs.yale.operator.learner.igss.hypothesis.Hypothesis;
import edu.udo.cs.yale.operator.learner.igss.utility.InstanceAveraging;

public class Accuracy
extends InstanceAveraging {
    public Accuracy(double[] priors, int large) {
        super(priors, large);
    }

    public double utility(double totalExampleWeight, double totalPositiveWeight, Hypothesis hypo) {
        double fp = hypo.getCoveredWeight() - hypo.getPositiveWeight();
        double tn = totalExampleWeight - totalPositiveWeight - fp;
        return (hypo.getPositiveWeight() + tn) / totalExampleWeight;
    }

    public double variance(double totalWeight, double totalPositiveWeight, Hypothesis hypo) {
        double fp = hypo.getCoveredWeight() - hypo.getPositiveWeight();
        double tn = totalWeight - totalPositiveWeight - fp;
        double correctPredictions = hypo.getPositiveWeight() + tn;
        double mean = correctPredictions / totalWeight;
        double innerTerm = correctPredictions * Math.pow(1.0 - mean, 2.0) + (totalWeight - correctPredictions) * Math.pow(0.0 - mean, 2.0);
        return Math.sqrt(innerTerm) / totalWeight;
    }

    public double getUpperBound(double totalWeight, double totalPositiveWeight, Hypothesis hypo, double delta) {
        Hypothesis h = hypo.clone();
        h.setCoveredWeight(hypo.getPositiveWeight());
        double util = this.utility(totalWeight, totalPositiveWeight, h);
        double conf = this.confidenceIntervall(totalWeight, delta);
        return util + conf;
    }
}

