/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.igss.hypothesis;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.PredictionModel;
import edu.udo.cs.yale.operator.learner.igss.hypothesis.Hypothesis;
import edu.udo.cs.yale.tools.Tools;
import java.util.Iterator;

public class GSSModel
extends PredictionModel {
    protected Hypothesis hypothesis;
    protected double[] confidences;
    protected static Attribute[] regularAttributes;
    protected boolean crisp = true;

    public GSSModel(Attribute label) {
        super(label);
    }

    public GSSModel(Attribute label, Hypothesis hypothesis, double[] confidences) {
        super(label);
        this.hypothesis = hypothesis.clone();
        this.confidences = new double[2];
        this.confidences[0] = confidences[0];
        this.confidences[1] = confidences[1];
    }

    public boolean equals(Object o) {
        if (!(o instanceof GSSModel)) {
            return false;
        }
        GSSModel otherModel = (GSSModel)o;
        return otherModel.hypothesis.equals(this.hypothesis);
    }

    public int hashCode() {
        return this.hypothesis.hashCode();
    }

    public int getPredictionIndex() {
        if (this.confidences[1] >= this.confidences[0]) {
            return 1;
        }
        return 0;
    }

    public void performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        boolean worstPrediction;
        boolean bestPrediction;
        Iterator reader = exampleSet.iterator();
        if (this.confidences[1] >= this.confidences[0]) {
            bestPrediction = true;
            worstPrediction = false;
        } else {
            bestPrediction = false;
            worstPrediction = true;
        }
        while (reader.hasNext()) {
            Example e = (Example)reader.next();
            if (this.applicable(e)) {
                e.setValue(predictedLabel, (double)bestPrediction);
            } else {
                e.setValue(predictedLabel, (double)worstPrediction);
            }
            e.setConfidence(this.getLabel().getMapping().mapIndex(0), this.confidences[0]);
            e.setConfidence(this.getLabel().getMapping().mapIndex(1), this.confidences[1]);
        }
    }

    public boolean applicable(Example example) {
        return this.hypothesis.applicable(example);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(Tools.getLineSeparator());
        result.append(this.hypothesis);
        return result.toString();
    }

    public Hypothesis getHypothesis() {
        return this.hypothesis;
    }
}

