/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.igss;

import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.ResultObjectAdapter;
import edu.udo.cs.yale.operator.learner.igss.Result;
import edu.udo.cs.yale.operator.learner.igss.hypothesis.Hypothesis;
import edu.udo.cs.yale.tools.Tools;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGSSResult
extends ResultObjectAdapter {
    private LinkedList<Result> results;
    private double[] priors;

    public IGSSResult(ExampleSet eSet) {
        this.priors = IGSSResult.getPriors(eSet);
        this.results = new LinkedList();
    }

    public void addResult(Result r) {
        this.results.addLast(r);
    }

    public LinkedList<Result> getResults() {
        return this.results;
    }

    public double[] getPriors() {
        return this.priors;
    }

    public static double[] getPriors(ExampleSet exampleSet) {
        Iterator reader = exampleSet.iterator();
        double totalWeight = 0.0;
        double totalPositiveWeight = 0.0;
        while (reader.hasNext()) {
            Example e = (Example)reader.next();
            totalWeight += e.getWeight();
            if ((int)e.getLabel() != 1) continue;
            totalPositiveWeight += e.getWeight();
        }
        double[] result = new double[2];
        result[1] = totalPositiveWeight / totalWeight;
        result[0] = 1.0 - result[1];
        return result;
    }

    public static double calculateDiversity(ExampleSet exampleSet, LinkedList theResults) {
        Iterator reader = exampleSet.iterator();
        int[][] predictionMatrix = new int[exampleSet.size()][2];
        int i = 0;
        while (reader.hasNext()) {
            Example e = (Example)reader.next();
            Iterator it = theResults.iterator();
            while (it.hasNext()) {
                Hypothesis hypo = ((Result)it.next()).getHypothesis();
                if (hypo.applicable(e)) {
                    int[] nArray = predictionMatrix[i];
                    int n = hypo.getPrediction();
                    nArray[n] = nArray[n] + 1;
                    continue;
                }
                int[] nArray = predictionMatrix[i];
                int n = 1 - hypo.getPrediction();
                nArray[n] = nArray[n] + 1;
            }
            ++i;
        }
        double sum1 = 0.0;
        int i2 = 0;
        while (i2 < predictionMatrix.length) {
            if (predictionMatrix[i2][0] != 0 && predictionMatrix[i2][1] != 0) {
                double p0 = (double)predictionMatrix[i2][0] / (double)theResults.size();
                double p1 = (double)predictionMatrix[i2][1] / (double)theResults.size();
                sum1 = sum1 + -1.0 * p0 * IGSSResult.log2(p0) + -1.0 * p1 * IGSSResult.log2(p1);
            }
            ++i2;
        }
        double result = sum1 / (double)predictionMatrix.length;
        return result;
    }

    public String toString() {
        LinkedList<Result> includedResultsForDiversityCalculation = new LinkedList<Result>();
        String result = "(Rule, Utility)" + Tools.getLineSeparator();
        Iterator it = this.results.iterator();
        double cumulativeWeight = 0.0;
        int i = 1;
        while (it.hasNext()) {
            result = String.valueOf(result) + i + ") ";
            Result r = (Result)it.next();
            includedResultsForDiversityCalculation.addLast(r);
            cumulativeWeight += r.getTotalWeight();
            result = String.valueOf(result) + r.getHypothesis().toString() + ", " + r.getUtility() + Tools.getLineSeparator();
            ++i;
        }
        result = String.valueOf(result) + "total necessary example weight: " + cumulativeWeight + Tools.getLineSeparator();
        result = String.valueOf(result) + "a priori probability: " + this.priors[1] + Tools.getLineSeparator();
        return result;
    }

    public static double log2(double arg) {
        return Math.log(arg) / Math.log(2.0);
    }

    @Override
    public String getExtension() {
        return "gss";
    }

    @Override
    public String getFileDescription() {
        return "IGSS results";
    }
}

