/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.functions;

import Jama.Matrix;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.PredictionModel;
import edu.udo.cs.yale.tools.Tools;

public class OrdinalLogisticRegressionModel
extends PredictionModel {
    private Matrix beta = null;

    public OrdinalLogisticRegressionModel(Attribute label, Matrix beta) {
        super(label);
        this.beta = beta;
    }

    public double[] predict(Example example) {
        int J = this.beta.getRowDimension() - example.getAttributes().size();
        double[] cumProbs = new double[J];
        int j = 0;
        while (j < J) {
            cumProbs[j] = this.beta.get(j, 0);
            int i = 0;
            for (Attribute attribute : example.getAttributes()) {
                String str = example.getValueAsString(attribute);
                double value = Double.valueOf(str);
                int n = j;
                cumProbs[n] = cumProbs[n] + this.beta.get(J + i, 0) * value;
                ++i;
            }
            cumProbs[j] = Math.exp(cumProbs[j]) / (1.0 + Math.exp(cumProbs[j]));
            ++j;
        }
        double[] probs = new double[J + 1];
        probs[0] = cumProbs[0];
        int j2 = 1;
        while (j2 < J) {
            probs[j2] = cumProbs[j2] - cumProbs[j2 - 1];
            ++j2;
        }
        probs[J] = 1.0 - cumProbs[J - 1];
        System.err.print("conf: ");
        j2 = 0;
        while (j2 < probs.length) {
            System.err.print(String.valueOf(probs[j2]) + " ");
            ++j2;
        }
        System.err.println();
        return probs;
    }

    public void performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        for (Example example : exampleSet) {
            double[] probs = this.predict(example);
            double maxProb = 0.0;
            int prediction = 0;
            int j = 0;
            while (j < probs.length) {
                if (probs[j] > maxProb) {
                    maxProb = probs[j];
                    prediction = j + 1;
                }
                ++j;
            }
            example.setValue(predictedLabel, prediction);
        }
    }

    public String toString() {
        StringBuffer modelString = new StringBuffer(super.toString());
        modelString.append(String.valueOf(Tools.getLineSeparator()) + Tools.getLineSeparator() + Tools.getLineSeparator());
        return modelString.toString();
    }
}

