/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.functions;

import Jama.Matrix;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.operator.learner.SimpleBinaryPredictionModel;
import edu.udo.cs.yale.tools.Tools;

public class LogisticRegressionModel
extends SimpleBinaryPredictionModel {
    private Matrix beta = null;

    public LogisticRegressionModel(Attribute label, Matrix beta) {
        super(label);
        this.beta = beta;
    }

    public double predict(Example example) {
        double e = 0.0;
        int i = 0;
        for (Attribute attribute : example.getAttributes()) {
            double value = example.getValue(attribute);
            e += this.beta.get(i, 0) * value;
            ++i;
        }
        double result = Math.exp(e) / (1.0 + Math.exp(e));
        return result;
    }

    public String toString() {
        StringBuffer modelString = new StringBuffer(super.toString());
        modelString.append(String.valueOf(Tools.getLineSeparator()) + Tools.getLineSeparator() + Tools.getLineSeparator());
        modelString.append("logit( P(Y = 1 ) ) = ");
        int i = 0;
        while (i < this.beta.getRowDimension()) {
            modelString.append(" ");
            if (this.beta.get(i, 0) > 0.0) {
                modelString.append("+");
            }
            ++i;
        }
        modelString.append(Tools.getLineSeparator());
        return modelString.toString();
    }
}

