/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.functions;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.SimplePredictionModel;
import edu.udo.cs.yale.tools.Tools;

public class LinearRegressionModel
extends SimplePredictionModel {
    private String[] attributeNames;
    private boolean[] selectedAttributes;
    private double[] coefficients;

    public LinearRegressionModel() {
    }

    public LinearRegressionModel(Attribute label) {
        super(label);
    }

    public LinearRegressionModel(Attribute label, String[] attributeNames, boolean[] selectedAttributes, double[] coefficients) {
        super(label);
        this.attributeNames = attributeNames;
        this.selectedAttributes = selectedAttributes;
        this.coefficients = coefficients;
    }

    public double predict(Example example) throws OperatorException {
        double prediction = 0.0;
        int index = 0;
        int attributeCounter = 0;
        for (Attribute attribute : example.getAttributes()) {
            if (this.selectedAttributes[attributeCounter]) {
                prediction += this.coefficients[index] * example.getValue(attribute);
                ++index;
            }
            ++attributeCounter;
        }
        return prediction += this.coefficients[index];
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        int index = 0;
        int i = 0;
        while (i < this.selectedAttributes.length) {
            if (this.selectedAttributes[i]) {
                result.append(String.valueOf(this.getCoefficientString(this.coefficients[index], first)) + " * " + this.attributeNames[i] + Tools.getLineSeparator());
                ++index;
                first = false;
            }
            ++i;
        }
        result.append(this.getCoefficientString(this.coefficients[this.coefficients.length - 1], first));
        return result.toString();
    }

    private String getCoefficientString(double coefficient, boolean first) {
        if (!first) {
            if (coefficient >= 0.0) {
                return "+ " + Tools.formatNumber(Math.abs(coefficient));
            }
            return "- " + Tools.formatNumber(Math.abs(coefficient));
        }
        if (coefficient >= 0.0) {
            return "  " + Tools.formatNumber(Math.abs(coefficient));
        }
        return "- " + Tools.formatNumber(Math.abs(coefficient));
    }
}

