/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.functions;

import Jama.Matrix;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.AbstractLearner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.functions.LinearRegressionModel;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearRegression
extends AbstractLearner {
    public static final String[] FEATURE_SELECTION_METHODS = new String[]{"none", "M5 prime", "greedy"};
    public static final int NO_SELECTION = 0;
    public static final int M5_PRIME = 1;
    public static final int GREEDY = 2;

    public LinearRegression(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        int numberOfAttributes = exampleSet.getAttributes().size();
        boolean[] attributeSelection = new boolean[numberOfAttributes];
        int counter = 0;
        String[] attributeNames = new String[numberOfAttributes];
        for (Attribute attribute : exampleSet.getAttributes()) {
            attributeSelection[counter] = !attribute.isNominal();
            attributeNames[counter] = attribute.getName();
            ++counter;
        }
        exampleSet.recalculateAllAttributeStatistics();
        double[] means = new double[numberOfAttributes];
        double[] standardDeviations = new double[numberOfAttributes];
        counter = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (attributeSelection[counter]) {
                NumericalAttributeStatistics stats = (NumericalAttributeStatistics)attribute.getStatistics();
                means[counter] = stats.getAverage();
                standardDeviations[counter] = Math.sqrt(stats.getVariance());
                if (standardDeviations[counter] == 0.0) {
                    attributeSelection[counter] = false;
                }
            }
            ++counter;
        }
        NumericalAttributeStatistics labelStats = (NumericalAttributeStatistics)exampleSet.getAttributes().getLabel().getStatistics();
        double labelMean = labelStats.getAverage();
        double classStandardDeviation = Math.sqrt(labelStats.getVariance());
        int numberOfExamples = exampleSet.size();
        double[] coefficients = new double[numberOfAttributes + 1];
        do {
            coefficients = this.performRegression(exampleSet, attributeSelection, means, labelMean);
        } while (this.getParameterAsBoolean("eliminate_colinear_features") && this.deselectAttributeWithHighestCoefficient(attributeSelection, coefficients, standardDeviations, classStandardDeviation));
        int currentlySelectedAttributes = 1;
        int i = 0;
        while (i < attributeSelection.length) {
            if (attributeSelection[i]) {
                ++currentlySelectedAttributes;
            }
            ++i;
        }
        double error = this.getSquaredError(exampleSet, attributeSelection, coefficients);
        double akaike = numberOfExamples - currentlySelectedAttributes + 2 * currentlySelectedAttributes;
        int currentNumberOfAttributes = currentlySelectedAttributes;
        switch (this.getParameterAsInt("feature_selection")) {
            case 2: {
                boolean improved;
                do {
                    boolean[] currentlySelected = (boolean[])attributeSelection.clone();
                    improved = false;
                    --currentNumberOfAttributes;
                    int i2 = 0;
                    while (i2 < attributeSelection.length) {
                        if (currentlySelected[i2]) {
                            currentlySelected[i2] = false;
                            double[] currentCoeffs = this.performRegression(exampleSet, currentlySelected, means, labelMean);
                            double currentMSE = this.getSquaredError(exampleSet, currentlySelected, currentCoeffs);
                            double currentAkaike = currentMSE / error * (double)(numberOfExamples - currentlySelectedAttributes) + (double)(2 * currentNumberOfAttributes);
                            if (currentAkaike < akaike) {
                                improved = true;
                                akaike = currentAkaike;
                                System.arraycopy(currentlySelected, 0, attributeSelection, 0, attributeSelection.length);
                                coefficients = currentCoeffs;
                            }
                            currentlySelected[i2] = true;
                        }
                        ++i2;
                    }
                } while (improved);
                break;
            }
            case 1: {
                boolean improved;
                do {
                    improved = false;
                    --currentNumberOfAttributes;
                    double minStadardizedCoefficient = 0.0;
                    int attribute2Deselect = -1;
                    int coefficientIndex = 0;
                    int i3 = 0;
                    while (i3 < attributeSelection.length) {
                        if (attributeSelection[i3]) {
                            double standardizedCoefficient = Math.abs(coefficients[coefficientIndex] * standardDeviations[i3] / classStandardDeviation);
                            if (coefficientIndex == 0 || standardizedCoefficient < minStadardizedCoefficient) {
                                minStadardizedCoefficient = standardizedCoefficient;
                                attribute2Deselect = i3;
                            }
                            ++coefficientIndex;
                        }
                        ++i3;
                    }
                    if (attribute2Deselect < 0) continue;
                    attributeSelection[attribute2Deselect] = false;
                    double[] currentCoefficients = this.performRegression(exampleSet, attributeSelection, means, labelMean);
                    double currentError = this.getSquaredError(exampleSet, attributeSelection, currentCoefficients);
                    double currentAkaike = currentError / error * (double)(numberOfExamples - currentlySelectedAttributes) + (double)(2 * currentNumberOfAttributes);
                    if (currentAkaike < akaike) {
                        improved = true;
                        akaike = currentAkaike;
                        coefficients = currentCoefficients;
                        continue;
                    }
                    attributeSelection[attribute2Deselect] = true;
                } while (improved);
                break;
            }
        }
        return new LinearRegressionModel(exampleSet.getAttributes().getLabel(), attributeNames, attributeSelection, coefficients);
    }

    private boolean deselectAttributeWithHighestCoefficient(boolean[] selectedAttributes, double[] coefficients, double[] standardDeviations, double classStandardDeviation) throws UndefinedParameterError {
        double minCoefficient = this.getParameterAsDouble("min_standardized_coefficient");
        int attribute2Deselect = -1;
        int coefficientIndex = 0;
        int i = 0;
        while (i < selectedAttributes.length) {
            if (selectedAttributes[i]) {
                double standardizedCoefficient = Math.abs(coefficients[coefficientIndex] * standardDeviations[i] / classStandardDeviation);
                if (standardizedCoefficient > minCoefficient) {
                    minCoefficient = standardizedCoefficient;
                    attribute2Deselect = i;
                }
                ++coefficientIndex;
            }
            ++i;
        }
        if (attribute2Deselect >= 0) {
            selectedAttributes[attribute2Deselect] = false;
            return true;
        }
        return false;
    }

    private double getSquaredError(ExampleSet exampleSet, boolean[] selectedAttributes, double[] coefficients) {
        double error = 0.0;
        for (Example example : exampleSet) {
            double prediction = this.regressionPrediction(example, selectedAttributes, coefficients);
            double diff = prediction - example.getLabel();
            error += diff * diff;
        }
        return error;
    }

    private double regressionPrediction(Example example, boolean[] selectedAttributes, double[] coefficients) {
        double prediction = 0.0;
        int index = 0;
        int counter = 0;
        for (Attribute attribute : example.getAttributes()) {
            if (!selectedAttributes[counter++]) continue;
            prediction += coefficients[index] * example.getValue(attribute);
            ++index;
        }
        return prediction += coefficients[index];
    }

    private double[] performRegression(ExampleSet exampleSet, boolean[] selectedAttributes, double[] means, double labelMean) throws UndefinedParameterError {
        int currentlySelectedAttributes = 0;
        int i = 0;
        while (i < selectedAttributes.length) {
            if (selectedAttributes[i]) {
                ++currentlySelectedAttributes;
            }
            ++i;
        }
        Matrix independent = null;
        Matrix dependent = null;
        double[] weights = null;
        if (currentlySelectedAttributes > 0) {
            independent = new Matrix(exampleSet.size(), currentlySelectedAttributes);
            dependent = new Matrix(exampleSet.size(), 1);
            int exampleIndex = 0;
            Iterator i2 = exampleSet.iterator();
            weights = new double[exampleSet.size()];
            Attribute weightAttribute = exampleSet.getAttributes().getWeight();
            while (i2.hasNext()) {
                Example example = (Example)i2.next();
                int attributeIndex = 0;
                dependent.set(exampleIndex, 0, example.getLabel());
                int counter = 0;
                for (Attribute attribute : exampleSet.getAttributes()) {
                    if (selectedAttributes[counter]) {
                        double value = example.getValue(attribute) - means[counter];
                        independent.set(exampleIndex, attributeIndex, value);
                        ++attributeIndex;
                    }
                    ++counter;
                }
                weights[exampleIndex] = weightAttribute != null ? example.getValue(weightAttribute) : 1.0;
                ++exampleIndex;
            }
        }
        double[] coefficients = new double[currentlySelectedAttributes + 1];
        if (currentlySelectedAttributes > 0) {
            double[] coefficientsWithoutIntercept = new edu.udo.cs.yale.tools.math.LinearRegression(independent, dependent, weights, this.getParameterAsDouble("ridge")).getCoefficients();
            System.arraycopy(coefficientsWithoutIntercept, 0, coefficients, 0, currentlySelectedAttributes);
        }
        coefficients[currentlySelectedAttributes] = labelMean;
        int coefficientIndex = 0;
        int i3 = 0;
        while (i3 < selectedAttributes.length) {
            if (selectedAttributes[i3]) {
                int n = coefficients.length - 1;
                coefficients[n] = coefficients[n] - coefficients[coefficientIndex] * means[i3];
                ++coefficientIndex;
            }
            ++i3;
        }
        return coefficients;
    }

    @Override
    public boolean supportsCapability(LearnerCapability lc) {
        if (lc.equals(LearnerCapability.BINOMINAL_ATTRIBUTES)) {
            return true;
        }
        if (lc.equals(LearnerCapability.NUMERICAL_ATTRIBUTES)) {
            return true;
        }
        return lc.equals(LearnerCapability.NUMERICAL_CLASS);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory("feature_selection", "The feature selection method used during regression.", FEATURE_SELECTION_METHODS, 1));
        types.add(new ParameterTypeBoolean("eliminate_colinear_features", "Indicates if the algorithm should try to delete colinear features during the regression.", true));
        types.add(new ParameterTypeDouble("min_standardized_coefficient", "The minimum standardized coefficient for the removal of colinear feature elimination.", 0.0, Double.POSITIVE_INFINITY, 1.5));
        types.add(new ParameterTypeDouble("ridge", "The ridge parameter used during ridge regression.", 0.0, Double.POSITIVE_INFINITY, 1.0E-8));
        return types;
    }
}

