/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.bayes;

import edu.udo.cs.yale.operator.learner.Distribution;
import edu.udo.cs.yale.tools.Tools;

public class NormalDistribution
implements Distribution {
    private double mean;
    private double variance;
    private double scaleFactor;

    public NormalDistribution(double mean, double variance) {
        this.mean = mean;
        this.variance = variance;
        this.scaleFactor = 1.0 / (variance * Math.sqrt(Math.PI * 2));
    }

    public double getProbability(double x) {
        return this.scaleFactor * Math.exp(-0.5 * Math.pow((x - this.mean) / this.variance, 2.0));
    }

    public String toString() {
        return "Mean: " + Tools.formatNumber(this.mean) + "   Standard Deviation: " + Tools.formatNumber(this.variance);
    }
}

