/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.bayes;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.Distribution;
import edu.udo.cs.yale.operator.learner.DistributionPlotter;
import edu.udo.cs.yale.operator.learner.SimplePredictionModel;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionModel
extends SimplePredictionModel {
    private Map<Integer, Map<Integer, Distribution>> classDistributions;
    private int numberOfClasses;
    private double[] classProbabilities;
    private String[] attributeNames;

    public DistributionModel(Attribute labelAttribute, int numberOfClasses, double[] classProbabilities, String[] attributeNames) {
        super(labelAttribute);
        this.numberOfClasses = numberOfClasses;
        this.classProbabilities = (double[])classProbabilities.clone();
        this.classDistributions = new HashMap<Integer, Map<Integer, Distribution>>(numberOfClasses);
        this.attributeNames = attributeNames;
    }

    public void addDistribution(int classIndex, int attributeIndex, Distribution distribution) {
        Map<Object, Object> attributes;
        if (this.classDistributions.containsKey(classIndex)) {
            attributes = this.classDistributions.get(classIndex);
        } else {
            attributes = new HashMap();
            this.classDistributions.put(classIndex, attributes);
        }
        attributes.put(attributeIndex, distribution);
    }

    @Override
    public double predict(Example example) throws OperatorException {
        double maxProbability = 0.0;
        int maxProbableClass = 0;
        int i = 0;
        while (i < this.numberOfClasses) {
            double probability = this.getProbabilityForClass(i, example);
            if (probability > maxProbability) {
                maxProbability = probability;
                maxProbableClass = i;
            }
            ++i;
        }
        return maxProbableClass;
    }

    private double getProbabilityForClass(int classIndex, Example example) {
        double probability = this.classProbabilities[classIndex];
        int i = 0;
        for (Attribute attribute : example.getAttributes()) {
            probability *= this.getProbabilityForAttribute(classIndex, attribute, i++, example);
        }
        return probability;
    }

    private double getProbabilityForAttribute(int classIndex, Attribute attribute, int attributeIndex, Example example) {
        Distribution distribution = this.classDistributions.get(classIndex).get(attributeIndex);
        return distribution.getProbability(example.getValue(attribute));
    }

    public Component getVisualisationComponent(IOContainer container) {
        return new DistributionPlotter(this);
    }

    @Override
    public String toResultString() {
        StringBuffer buffer = new StringBuffer();
        for (Integer i : this.classDistributions.keySet()) {
            buffer.append("Class " + this.getLabel().getMapping().mapIndex(i) + " (" + Tools.formatNumber(this.classProbabilities[i]) + "):" + Tools.getLineSeparator() + Tools.getLineSeparator());
            for (Integer j : this.classDistributions.get(i).keySet()) {
                buffer.append("Attribute " + this.attributeNames[j] + Tools.getLineSeparator());
                buffer.append(this.classDistributions.get(i).get(j).toString());
                buffer.append(Tools.getLineSeparator());
            }
            buffer.append(Tools.getLineSeparator());
        }
        return buffer.toString();
    }

    public Iterator<Integer> getClasses() {
        return this.classDistributions.keySet().iterator();
    }

    public Iterator<Integer> getAttributes(int classIndex) {
        return this.classDistributions.get(classIndex).keySet().iterator();
    }

    public Distribution getDistribution(int classIndex, int attributeIndex) {
        return this.classDistributions.get(classIndex).get(attributeIndex);
    }
}

