/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.bayes;

import edu.udo.cs.yale.operator.learner.Distribution;
import edu.udo.cs.yale.tools.Tools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscreteDistribution
implements Distribution {
    ArrayList<Double> values;
    ArrayList<Double> occurences;
    int totalOccurences = 0;
    int totalValueNumber = 0;
    double totalProbability = 0.0;

    public DiscreteDistribution(Set<Double> possibleValues, int possibleValueNumber, Collection<Double> allValues) {
        this.totalValueNumber = possibleValueNumber;
        this.values = new ArrayList();
        this.occurences = new ArrayList();
        for (Double value : possibleValues) {
            this.values.add(value);
            double occurences = Collections.frequency(allValues, value);
            this.totalOccurences = (int)((double)this.totalOccurences + occurences);
            this.occurences.add(occurences);
        }
        int i = 0;
        while (i < this.occurences.size()) {
            Double value = this.occurences.get(i);
            double valueD = value;
            valueD = (valueD + 1.0) / (double)(this.totalOccurences + this.totalValueNumber);
            this.occurences.set(i, valueD);
            this.totalProbability += valueD;
            ++i;
        }
    }

    @Override
    public double getProbability(double x) {
        int i = 0;
        while (i < this.values.size()) {
            if (this.values.get(i).equals(x)) {
                return this.occurences.get(i);
            }
            ++i;
        }
        return (1.0 - this.totalProbability) / (double)(this.totalValueNumber - this.values.size());
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.values.size()) {
            buffer.append(String.valueOf(Tools.formatNumber(this.values.get(i))) + "   ");
            ++i;
        }
        buffer.append(Tools.getLineSeparator());
        i = 0;
        while (i < this.values.size()) {
            buffer.append(String.valueOf(Tools.formatIntegerIfPossible(this.occurences.get(i))) + "   ");
            ++i;
        }
        buffer.append("  else " + Tools.formatNumber((1.0 - this.totalProbability) / (double)(this.totalValueNumber - this.values.size())));
        buffer.append(" (sum: " + Tools.formatIntegerIfPossible(this.totalOccurences) + ")");
        return buffer.toString();
    }
}

