/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.PredictionModel;

public abstract class SimpleBinaryPredictionModel
extends PredictionModel {
    protected SimpleBinaryPredictionModel() {
    }

    protected SimpleBinaryPredictionModel(Attribute label) {
        super(label);
    }

    public abstract double predict(Example var1) throws OperatorException;

    public void performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        if (!predictedLabel.isNominal()) {
            throw new OperatorException(String.valueOf(this.getName()) + ": non-nominal label attributes not supported!");
        }
        if (predictedLabel.getMapping().getValues().size() != 2) {
            throw new OperatorException(String.valueOf(this.getName()) + ": non-binary label attributes not supported!");
        }
        for (Example example : exampleSet) {
            double functionValue = this.predict(example);
            if (functionValue > 0.0) {
                example.setValue(predictedLabel, this.getLabel().getMapping().getPositiveIndex());
            } else {
                example.setValue(predictedLabel, this.getLabel().getMapping().getNegativeIndex());
            }
            example.setConfidence(this.getLabel().getMapping().mapIndex(predictedLabel.getMapping().getPositiveIndex()), 1.0 / (1.0 + Math.exp(-functionValue)));
            example.setConfidence(this.getLabel().getMapping().mapIndex(predictedLabel.getMapping().getNegativeIndex()), 1.0 / (1.0 + Math.exp(functionValue)));
        }
    }
}

