/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.operator.AbstractModel;
import edu.udo.cs.yale.operator.OperatorException;

public abstract class PredictionModel
extends AbstractModel {
    private Attribute label;

    protected PredictionModel() {
    }

    protected PredictionModel(Attribute label) {
        this.label = label;
    }

    public abstract void performPrediction(ExampleSet var1, Attribute var2) throws OperatorException;

    public void apply(ExampleSet exampleSet) throws OperatorException {
        Attribute predictedLabel = this.createPredictedLabel(exampleSet);
        this.performPrediction(exampleSet, predictedLabel);
    }

    public void setLabel(Attribute label) {
        this.label = label;
    }

    public Attribute getLabel() {
        return this.label;
    }

    protected Attribute createPredictedLabel(ExampleSet exampleSet) {
        Attribute label = this.getLabel();
        Attribute predictedLabel = AttributeFactory.createAttribute(label, "prediction");
        ExampleTable table = exampleSet.getExampleTable();
        table.addAttribute(predictedLabel);
        exampleSet.getAttributes().setPredictedLabel(predictedLabel);
        if (label.isNominal()) {
            for (String value : predictedLabel.getMapping().getValues()) {
                Attribute confidence = AttributeFactory.createAttribute("confidence(" + value + ")", 4);
                table.addAttribute(confidence);
                exampleSet.getAttributes().setSpecialAttribute(confidence, "confidence(" + value + ")");
            }
        }
        return predictedLabel;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " (prediction model for label " + this.label + ")";
    }

    public static void removePredictedLabel(ExampleSet exampleSet) {
        Attribute predictedLabel = exampleSet.getAttributes().getPredictedLabel();
        if (predictedLabel != null) {
            if (predictedLabel.isNominal()) {
                for (String value : predictedLabel.getMapping().getValues()) {
                    Attribute currentConfidenceAttribute = exampleSet.getAttributes().getSpecial("confidence(" + value + ")");
                    if (currentConfidenceAttribute == null) continue;
                    exampleSet.getAttributes().remove(currentConfidenceAttribute);
                    exampleSet.getExampleTable().removeAttribute(currentConfidenceAttribute);
                }
            }
            exampleSet.getAttributes().remove(predictedLabel);
            exampleSet.getExampleTable().removeAttribute(predictedLabel);
        }
    }
}

