/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.AbstractLearner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.SimplePredictionModel;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiCriterionDecisionStumps
extends AbstractLearner {
    private static final String ACC = "accuracy";
    private static final String ENTROPY = "entropy";
    private static final String SQRT_PN = "sqrt(TP*FP) + sqrt(FN*TN)";
    private static final String GINI = "gini index";
    private static final String CHI_SQUARE = "chi square test";
    private static final String[] UTILITY_FUNCTION_LIST = new String[]{"entropy", "accuracy", "sqrt(TP*FP) + sqrt(FN*TN)", "gini index", "chi square test"};
    private static final String UTILITY_FUNCTION = "utility_function";
    private int posIndex;
    private double globalP;
    private double globalN;
    private Model bestModel;
    private double bestScore;
    private String utilityFunction;

    public MultiCriterionDecisionStumps(OperatorDescription description) {
        super(description);
    }

    @Override
    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.POLYNOMINAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.BINOMINAL_ATTRIBUTES) {
            return true;
        }
        return lc == LearnerCapability.BINOMINAL_CLASS;
    }

    protected void initHighscore() {
        this.bestModel = null;
        this.bestScore = Double.NEGATIVE_INFINITY;
    }

    protected Model getBestModel() {
        return this.bestModel;
    }

    private void setBestModel(DecisionStumpModel model, double score) {
        this.bestModel = model;
        this.bestScore = score;
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        this.utilityFunction = UTILITY_FUNCTION_LIST[this.getParameterAsInt(UTILITY_FUNCTION)];
        this.initHighscore();
        this.posIndex = exampleSet.getAttributes().getLabel().getMapping().getPositiveIndex();
        double[] globalCounts = this.computePriors(exampleSet);
        this.globalP = globalCounts[0];
        this.globalN = globalCounts[1];
        boolean defaultModelPrecition = this.getScore(globalCounts, true) >= this.getScore(globalCounts, false);
        this.setBestModel(new DecisionStumpModel(null, 0.0, exampleSet.getAttributes().getLabel(), defaultModelPrecition, true), this.getScore(globalCounts, defaultModelPrecition));
        this.evaluateNominalAttributes(exampleSet);
        this.evaluateNumericalAttributes(exampleSet);
        return this.getBestModel();
    }

    private void evaluateNumericalAttributes(ExampleSet exampleSet) throws OperatorException {
        int numAttr = exampleSet.getAttributes().size();
        int[] mapAttribToIndex = new int[numAttr];
        Attribute[] mapIndexToAttrib = new Attribute[numAttr];
        int index = 0;
        int i = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNominal()) {
                mapIndexToAttrib[index] = attribute;
                mapAttribToIndex[i] = index++;
            } else {
                mapAttribToIndex[i] = -1;
            }
            ++i;
        }
        if (index == 0) {
            return;
        }
        boolean hasWeight = exampleSet.getAttributes().getWeight() != null;
        double[][] weightedLabel = new double[exampleSet.size()][2];
        double[][][] values = new double[index][exampleSet.size()][];
        Iterator reader = exampleSet.iterator();
        int exampleNum = 0;
        double[] weightedPriors = new double[2];
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            int label = example.getLabel() == (double)this.posIndex ? 0 : 1;
            double weight = hasWeight ? example.getWeight() : 1.0;
            int n = label;
            weightedPriors[n] = weightedPriors[n] + weight;
            weightedLabel[exampleNum] = new double[]{label, weight};
            int i2 = 0;
            while (i2 < index) {
                double attribValue = example.getValue(mapIndexToAttrib[i2]);
                values[i2][exampleNum] = new double[]{attribValue, exampleNum};
                ++i2;
            }
            ++exampleNum;
        }
        boolean predictNaN = weightedPriors[0] >= weightedPriors[1];
        Comparator<double[]> cmp = new Comparator<double[]>(){

            @Override
            public int compare(double[] arg0, double[] arg1) {
                return Double.compare(arg0[0], arg1[0]);
            }
        };
        Attribute labelAttribute = exampleSet.getAttributes().getLabel();
        int i3 = 0;
        while (i3 < index) {
            Attribute currentAttribute = mapIndexToAttrib[i3];
            double[][] currentAttributeValues = values[i3];
            Arrays.sort(currentAttributeValues, cmp);
            double[] counts = new double[exampleSet.getAttributes().getLabel().getMapping().size()];
            double lastValue = Double.NEGATIVE_INFINITY;
            double lastScore = Double.NEGATIVE_INFINITY;
            boolean betterPrediction = false;
            int j = 0;
            while (j < currentAttributeValues.length) {
                double curAttribValue = currentAttributeValues[j][0];
                if (Double.isNaN(curAttribValue) || curAttribValue == Double.POSITIVE_INFINITY) break;
                int curExampleNumber = (int)currentAttributeValues[j][1];
                int curLabel = (int)weightedLabel[curExampleNumber][0];
                double curWeight = weightedLabel[curExampleNumber][1];
                if (curAttribValue != lastValue && lastScore > this.bestScore) {
                    double testValue = (curAttribValue + lastValue) / 2.0;
                    boolean includeNaNs = predictNaN == betterPrediction;
                    DecisionStumpModel dsm = new DecisionStumpModel(currentAttribute, testValue, labelAttribute, betterPrediction, includeNaNs);
                    this.setBestModel(dsm, lastScore);
                }
                int n = curLabel;
                counts[n] = counts[n] + curWeight;
                double scorePos = this.getScore(counts, true);
                double scoreNeg = this.getScore(counts, false);
                lastScore = Math.max(scorePos, scoreNeg);
                betterPrediction = scorePos >= scoreNeg;
                lastValue = curAttribValue;
                ++j;
            }
            ++i3;
        }
    }

    private void evaluateNominalAttributes(ExampleSet exampleSet) throws OperatorException {
        int numAttr = exampleSet.getAttributes().size();
        int[] mapAttribToIndex = new int[numAttr];
        Attribute[] mapIndexToAttrib = new Attribute[numAttr];
        int index = 0;
        int i = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (attribute.isNominal()) {
                mapIndexToAttrib[index] = attribute;
                mapAttribToIndex[i] = index++;
            } else {
                mapAttribToIndex[i] = -1;
            }
            ++i;
        }
        if (index == 0) {
            return;
        }
        double[][][] counter = new double[index][][];
        double[][] countNaNs = new double[index][exampleSet.getAttributes().getLabel().getMapping().size()];
        int i2 = 0;
        while (i2 < index) {
            int numValues = mapIndexToAttrib[i2].getMapping().size();
            counter[i2] = new double[numValues][exampleSet.getAttributes().getLabel().getMapping().size()];
            ++i2;
        }
        Attribute weightAttr = exampleSet.getAttributes().getWeight();
        for (Example example : exampleSet) {
            double weight = weightAttr == null ? 1.0 : example.getWeight();
            int label = example.getLabel() == (double)this.posIndex ? 0 : 1;
            int i3 = 0;
            while (i3 < index) {
                double attributeValue = example.getValue(mapIndexToAttrib[i3]);
                if (Double.isNaN(attributeValue)) {
                    double[] dArray = countNaNs[i3];
                    int n = label;
                    dArray[n] = dArray[n] + weight;
                } else {
                    double[] dArray = counter[i3][(int)attributeValue];
                    int n = label;
                    dArray[n] = dArray[n] + weight;
                }
                ++i3;
            }
        }
        int i4 = 0;
        while (i4 < index) {
            double[][] attributeMatrix = counter[i4];
            int j = 0;
            while (j < attributeMatrix.length) {
                ScoreNaNInfo snp = this.getScore(attributeMatrix[j], countNaNs[i4]);
                if (snp.score > this.bestScore) {
                    Attribute attribute = mapIndexToAttrib[i4];
                    double testValue = j;
                    this.setBestModel(new DecisionStumpModel(attribute, testValue, exampleSet.getAttributes().getLabel(), snp.predicted, snp.includeNaNs), snp.score);
                }
                ++j;
            }
            ++i4;
        }
    }

    private ScoreNaNInfo getScore(double[] counts, double[] countNaNs) throws UndefinedParameterError {
        double score = this.getScore(counts, true);
        ScoreNaNInfo snp = new ScoreNaNInfo(score, false, true);
        score = this.getScore(counts, false);
        ScoreNaNInfo snp2 = new ScoreNaNInfo(score, false, false);
        snp = snp.max(snp2);
        if (countNaNs[0] > 0.0 || countNaNs[1] > 0.0) {
            counts[0] = counts[0] + countNaNs[0];
            counts[1] = counts[1] + countNaNs[1];
            score = this.getScore(counts, true);
            snp2 = new ScoreNaNInfo(score, true, true);
            snp = snp.max(snp2);
            score = this.getScore(counts, false);
            snp2 = new ScoreNaNInfo(score, true, false);
            snp = snp.max(snp2);
        }
        return snp;
    }

    protected double getScore(double[] counts, boolean predictPositives) {
        double score;
        double p = counts[0];
        double n = counts[1];
        if (this.utilityFunction.equals(ACC)) {
            score = predictPositives ? p - n : n - p;
        } else if (this.utilityFunction.equals(ENTROPY)) {
            if (p - n >= 0.0 ^ predictPositives) {
                return Double.NEGATIVE_INFINITY;
            }
            double cov = p + n;
            double uncov = this.globalP + this.globalN - cov;
            double scoreCovered = cov == 0.0 ? 0.0 : this.entropyLog2(p / cov) + this.entropyLog2(n / cov);
            double scoreUncovered = uncov == 0.0 ? 0.0 : this.entropyLog2((this.globalP - p) / uncov) + this.entropyLog2((this.globalN - n) / uncov);
            score = (cov * scoreCovered + uncov * scoreUncovered) / (cov + uncov);
            score = -score;
        } else if (this.utilityFunction.equals(SQRT_PN)) {
            if (p - n >= 0.0 ^ predictPositives) {
                return Double.NEGATIVE_INFINITY;
            }
            score = Math.sqrt(p * n) + Math.sqrt((this.globalP - p) * (this.globalN - n));
            score = -score;
        } else if (this.utilityFunction.equals(GINI)) {
            if (p - n >= 0.0 ^ predictPositives) {
                return Double.NEGATIVE_INFINITY;
            }
            double cov = p + n;
            double uncov = this.globalP + this.globalN - cov;
            double scoreCovered = cov == 0.0 ? 0.0 : p / cov * (n / cov);
            double scoreUncovered = uncov == 0.0 ? 0.0 : (this.globalP - p) / uncov * ((this.globalN - n) / uncov);
            score = (cov * scoreCovered + uncov * scoreUncovered) / (cov + uncov);
            score = -score;
        } else if (this.utilityFunction.equals(CHI_SQUARE)) {
            double q = this.globalP - p;
            double r = this.globalN - n;
            double cov = p + n;
            double uncov = q + r;
            double total = cov + uncov;
            double c11 = cov * this.globalP / total;
            double c12 = cov * this.globalN / total;
            double c21 = uncov * this.globalP / total;
            double c22 = uncov * this.globalN / total;
            score = cov > 0.0 && uncov > 0.0 ? (p - c11) * (p - c11) / c11 + (n - c12) * (n - c12) / c12 + (q - c21) * (q - c21) / c21 + (r - c22) * (r - c22) / c22 : 0.0;
        } else {
            score = Double.NaN;
            LogService.logMessage("Found unknown utility function: " + this.utilityFunction, 4);
        }
        return score;
    }

    private double entropyLog2(double p) {
        if (Double.isNaN(p) || p == 0.0) {
            return 0.0;
        }
        return -p * Math.log(p) / Math.log(2.0);
    }

    protected double[] computePriors(ExampleSet exampleSet) {
        Attribute weightAttr = exampleSet.getAttributes().getWeight();
        double p = 0.0;
        double n = 0.0;
        for (Example example : exampleSet) {
            double weight;
            double d = weight = weightAttr == null ? 1.0 : example.getValue(weightAttr);
            if (example.getLabel() == (double)this.posIndex) {
                p += weight;
                continue;
            }
            n += weight;
        }
        return new double[]{p, n};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory(UTILITY_FUNCTION, "The function to be optimized by the rule.", UTILITY_FUNCTION_LIST, 0));
        return types;
    }

    public static class DecisionStumpModel
    extends SimplePredictionModel {
        private final Attribute testAttribute;
        private final double testValue;
        private final boolean prediction;
        private boolean includeNaNs;
        private final boolean numerical;

        public DecisionStumpModel(Attribute attribute, double testValue, Attribute label, boolean prediction, boolean includeNaNs) {
            this.setLabel(label);
            this.prediction = prediction;
            this.includeNaNs = includeNaNs;
            this.testAttribute = attribute;
            this.testValue = testValue;
            this.numerical = this.testAttribute == null || !this.testAttribute.isNominal();
        }

        public double predict(Example example) {
            boolean evaluatesToTrue;
            if (this.testAttribute == null) {
                evaluatesToTrue = true;
            } else {
                double exampleValue = example.getValue(this.testAttribute);
                if (Double.isNaN(exampleValue)) {
                    evaluatesToTrue = this.includeNaNs;
                } else if (this.numerical) {
                    evaluatesToTrue = example.getValue(this.testAttribute) <= this.testValue;
                } else {
                    boolean bl = evaluatesToTrue = example.getValue(this.testAttribute) == this.testValue;
                }
            }
            if (evaluatesToTrue == this.prediction) {
                return this.getLabel().getMapping().getPositiveIndex();
            }
            return this.getLabel().getMapping().getNegativeIndex();
        }

        public String toString() {
            String posIndexS = this.getLabel().getMapping().getPositiveString();
            String negIndexS = this.getLabel().getMapping().getNegativeString();
            StringBuffer result = new StringBuffer(super.toString());
            result.append(String.valueOf(Tools.getLineSeparator()) + " (" + this.getLabel().getName() + "=");
            result.append(String.valueOf(this.prediction ? posIndexS : negIndexS) + ") <-- ");
            result.append(this.testAttribute != null ? String.valueOf(this.testAttribute.getName()) + (this.numerical ? " <= " + this.testValue : " = " + this.testAttribute.getMapping().mapIndex((int)this.testValue)) : "");
            result.append(String.valueOf(Tools.getLineSeparator()) + " unknown: predict '" + (this.includeNaNs ? posIndexS : negIndexS) + "'.");
            return result.toString();
        }
    }

    private static class ScoreNaNInfo {
        public double score;
        public boolean includeNaNs;
        public boolean predicted;

        ScoreNaNInfo(double score, boolean includeNaNs, boolean predicted) {
            this.score = score;
            this.includeNaNs = includeNaNs;
            this.predicted = predicted;
        }

        public ScoreNaNInfo max(ScoreNaNInfo other) {
            if (this.score >= other.score) {
                return this;
            }
            return other;
        }
    }
}

