/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner;

import edu.udo.cs.yale.gui.plotter.PlotterAdapter;
import edu.udo.cs.yale.operator.learner.Distribution;
import edu.udo.cs.yale.operator.learner.bayes.DistributionModel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class DistributionPlotter
extends PlotterAdapter {
    private static final long serialVersionUID = 2923008541302883925L;
    private transient DistributionModel model;

    public DistributionPlotter(DistributionModel model) {
        this.model = model;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int pixWidth = this.getWidth() - 40;
        int pixHeight = this.getHeight() - 40;
        Graphics2D translated = (Graphics2D)graphics.create();
        translated.translate(20, 20);
        this.paintDistributions(translated, pixWidth, pixHeight);
    }

    private void paintDistributions(Graphics2D g, int pixWidth, int pixHeight) {
        int classIndex = this.model.getClasses().next();
        int attributeIndex = this.model.getAttributes(classIndex).next();
        g.setColor(Color.BLACK);
        g.draw(new Rectangle2D.Double(0.0, 0.0, 300.0, 100.0));
        this.paintDistribution(g, this.model.getDistribution(classIndex, attributeIndex), Color.RED, 300, 100, 60.0, 110.0, 4);
    }

    private void paintDistribution(Graphics2D g, Distribution distribution, Color color, int width, int height, double start, double end, int zoomFactor) {
        double valueInterval = (end - start) / (double)width;
        double currentValue = start;
        g.setColor(color);
        int lastX = 0;
        double currentProbability = distribution.getProbability(currentValue);
        int lastY = height - (int)(currentProbability * (double)height);
        int x = 1;
        while (x < width) {
            currentProbability = distribution.getProbability(currentValue);
            int y = height - (int)(currentProbability * (double)(height * zoomFactor));
            g.drawLine(lastX, lastY, x, y);
            currentValue += valueInterval;
            lastX = x++;
            lastY = y;
        }
    }
}

