/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner;

import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.Tools;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.InputDescription;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Saveable;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.learner.Learner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import java.util.LinkedList;

public abstract class AbstractLearner
extends Operator
implements Learner {
    public AbstractLearner(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        PerformanceVector optimizationPerformance;
        AttributeWeights weights;
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        if (exampleSet.getAttributes().getLabel() == null) {
            throw new UserError(this, 105);
        }
        if (exampleSet.getAttributes().getLabel().isNominal() && exampleSet.getAttributes().getLabel().getMapping().size() <= 1) {
            throw new UserError((Operator)this, 118, new Object[]{exampleSet.getAttributes().getLabel(), exampleSet.getAttributes().getLabel().getMapping().size(), "at least 2"});
        }
        if (exampleSet.getAttributes().size() == 0) {
            throw new UserError(this, 106);
        }
        if (exampleSet.size() == 0) {
            throw new UserError(this, 117);
        }
        try {
            this.checkLearnerCapabilities(exampleSet);
        }
        catch (OperatorException e) {
            LogService.logMessage(e.getMessage(), 4);
        }
        LinkedList<Saveable> results = new LinkedList<Saveable>();
        Model model = this.learn(exampleSet);
        results.add(model);
        if (this.shouldCalculateWeights() && (weights = this.getWeights(exampleSet)) != null) {
            results.add(weights);
        }
        PerformanceVector perfVector = null;
        if (this.shouldEstimatePerformance()) {
            perfVector = this.getEstimatedPerformance();
        }
        if (this.shouldDeliverOptimizationPerformance() && (optimizationPerformance = this.getOptimizationPerformance()) != null && perfVector == null) {
            perfVector = optimizationPerformance;
        }
        if (perfVector != null) {
            results.add(perfVector);
        }
        IOObject[] resultArray = new IOObject[results.size()];
        results.toArray(resultArray);
        return resultArray;
    }

    public void checkLearnerCapabilities(ExampleSet exampleSet) throws OperatorException {
        if (Tools.containsValueType(exampleSet, 1)) {
            if (Tools.containsValueType(exampleSet, 8)) {
                if (!this.supportsCapability(LearnerCapability.BINOMINAL_ATTRIBUTES)) {
                    throw new UserError((Operator)this, 501, LearnerCapability.BINOMINAL_ATTRIBUTES.getDescription());
                }
            } else if (!this.supportsCapability(LearnerCapability.POLYNOMINAL_ATTRIBUTES)) {
                throw new UserError((Operator)this, 501, LearnerCapability.POLYNOMINAL_ATTRIBUTES.getDescription());
            }
        } else if (Tools.containsValueType(exampleSet, 2) && !this.supportsCapability(LearnerCapability.NUMERICAL_ATTRIBUTES)) {
            throw new UserError((Operator)this, 501, LearnerCapability.NUMERICAL_ATTRIBUTES.getDescription());
        }
        if (exampleSet.getAttributes().getLabel().isNominal()) {
            if (exampleSet.getAttributes().getLabel().getMapping().size() == 2) {
                if (!this.supportsCapability(LearnerCapability.BINOMINAL_CLASS)) {
                    throw new UserError((Operator)this, 501, LearnerCapability.BINOMINAL_CLASS.getDescription());
                }
            } else if (!this.supportsCapability(LearnerCapability.POLYNOMINAL_CLASS)) {
                throw new UserError((Operator)this, 501, LearnerCapability.POLYNOMINAL_CLASS.getDescription());
            }
        } else if (!exampleSet.getAttributes().getLabel().isNominal() && !this.supportsCapability(LearnerCapability.NUMERICAL_CLASS)) {
            throw new UserError((Operator)this, 501, LearnerCapability.NUMERICAL_CLASS.getDescription());
        }
    }

    public boolean shouldEstimatePerformance() {
        return false;
    }

    public boolean shouldCalculateWeights() {
        return false;
    }

    public boolean shouldDeliverOptimizationPerformance() {
        return false;
    }

    public PerformanceVector getEstimatedPerformance() throws OperatorException {
        throw new UserError((Operator)this, 912, this.getName(), (Object)"estimation of performance not supported.");
    }

    public PerformanceVector getOptimizationPerformance() throws OperatorException {
        throw new UserError((Operator)this, 912, this.getName(), (Object)"delivering the original optimization performance is not supported.");
    }

    public AttributeWeights getWeights(ExampleSet exampleSet) throws OperatorException {
        throw new UserError((Operator)this, 916, this.getName(), (Object)"calculation of weights not supported.");
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    public Class[] getOutputClasses() {
        LinkedList<Class<AttributeWeights>> classList = new LinkedList<Class<AttributeWeights>>();
        classList.add(Model.class);
        if (this.shouldEstimatePerformance()) {
            classList.add(PerformanceVector.class);
        }
        if (this.shouldCalculateWeights()) {
            classList.add(AttributeWeights.class);
        }
        Class[] result = new Class[classList.size()];
        classList.toArray(result);
        return result;
    }
}

