/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XrffExampleSource
extends Operator {
    public XrffExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        File file = this.getParameterAsFile("data_file");
        String idName = this.getParameterAsString("id_attribute");
        Attribute label = null;
        Attribute id = null;
        Attribute weight = null;
        boolean instanceWeightsUsed = false;
        MemoryExampleTable table = null;
        try {
            Document document = null;
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            }
            catch (SAXException e1) {
                throw new IOException(e1.getMessage());
            }
            catch (ParserConfigurationException e1) {
                throw new IOException(e1.getMessage());
            }
            Element datasetElement = document.getDocumentElement();
            if (!datasetElement.getTagName().equals("dataset")) {
                throw new IOException("Outer tag of XRFF file must be <dataset>.");
            }
            Element headerElement = this.retrieveSingleNode(datasetElement, "header");
            Element attributesElement = this.retrieveSingleNode(headerElement, "attributes");
            LinkedList<Attribute> attributeList = new LinkedList<Attribute>();
            NodeList attributes = attributesElement.getChildNodes();
            int i = 0;
            while (i < attributes.getLength()) {
                Node node = attributes.item(i);
                if (node instanceof Element) {
                    Element labelsElement;
                    Element attribute = (Element)node;
                    String tagName = attribute.getTagName();
                    if (!tagName.equals("attribute")) {
                        throw new IOException("Only tags <attribute> are allowed inside <attributes>, was " + tagName);
                    }
                    String name = attribute.getAttribute("name");
                    if (name == null) {
                        throw new IOException("The tag <attribute> needs a 'name' attribute.");
                    }
                    String classAttribute = attribute.getAttribute("class");
                    boolean isClass = classAttribute != null && classAttribute.equals("yes");
                    String valueType = attribute.getAttribute("type");
                    if (valueType == null) {
                        throw new IOException("The tag <attribute> needs a 'type' attribute.");
                    }
                    Attribute att = this.createAttribute(name, valueType);
                    if (att.isNominal() && (labelsElement = this.retrieveSingleNode(attribute, "labels", false)) != null) {
                        NodeList labels = labelsElement.getChildNodes();
                        int j = 0;
                        while (j < labels.getLength()) {
                            Node labelNode = labels.item(j);
                            if (labelNode instanceof Element) {
                                String labelTagName = labelNode.getNodeName();
                                if (!labelTagName.equals("label")) {
                                    throw new IOException("Only tags <label> are allowed inside <labels>, was " + labelTagName);
                                }
                                String labelValue = labelNode.getTextContent();
                                att.getMapping().mapString(labelValue);
                            }
                            ++j;
                        }
                    }
                    if (isClass) {
                        label = att;
                    }
                    if (idName != null && name.equals(idName)) {
                        id = att;
                    }
                    attributeList.add(att);
                }
                ++i;
            }
            weight = AttributeFactory.createAttribute("weight", 4);
            attributeList.add(weight);
            table = new MemoryExampleTable(attributeList);
            DataRowFactory factory = new DataRowFactory(this.getParameterAsInt("datamanagement"));
            Attribute[] attributeArray = new Attribute[attributeList.size()];
            attributeList.toArray(attributeArray);
            Element bodyElement = this.retrieveSingleNode(datasetElement, "body");
            Element instancesElement = this.retrieveSingleNode(bodyElement, "instances");
            NodeList instances = instancesElement.getChildNodes();
            int i2 = 0;
            while (i2 < instances.getLength()) {
                Node node = instances.item(i2);
                if (node instanceof Element) {
                    Element instance = (Element)node;
                    String tagName = instance.getTagName();
                    if (!tagName.equals("instance")) {
                        throw new IOException("Only tags <instance> are allowed inside <instances>, was " + tagName);
                    }
                    NodeList values = instance.getChildNodes();
                    int elementCount = 0;
                    int j = 0;
                    while (j < values.getLength()) {
                        if (values.item(j) instanceof Element) {
                            ++elementCount;
                        }
                        ++j;
                    }
                    if (elementCount != attributeList.size() - 1) {
                        throw new IOException("Number of values must be the same than the number of attributes.");
                    }
                    String[] valueArray = new String[attributeList.size()];
                    int index = 0;
                    int j2 = 0;
                    while (j2 < values.getLength()) {
                        Node valueNode = values.item(j2);
                        if (valueNode instanceof Element) {
                            Element valueElement = (Element)valueNode;
                            String valueTagName = valueElement.getTagName();
                            if (!valueTagName.equals("value")) {
                                throw new IOException("Only tags <value> are allowed inside <instance>, was " + valueTagName);
                            }
                            valueArray[index++] = valueNode.getTextContent();
                        }
                        ++j2;
                    }
                    String weightString = instance.getAttribute("weight");
                    if (weightString != null && weightString.length() > 0) {
                        valueArray[valueArray.length - 1] = weightString;
                        instanceWeightsUsed = true;
                    } else {
                        valueArray[valueArray.length - 1] = "1.0";
                    }
                    table.addDataRow(factory.create(valueArray, attributeArray));
                }
                ++i2;
            }
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 302, this.getParameterAsString("data_file"), (Object)e.getMessage());
        }
        ExampleSet result = table.createExampleSet(label, weight, id);
        if (!instanceWeightsUsed) {
            result.getAttributes().remove(weight);
            result.getExampleTable().removeAttribute(weight);
        }
        return new IOObject[]{result};
    }

    private Element retrieveSingleNode(Element element, String nodeName) throws IOException {
        return this.retrieveSingleNode(element, nodeName, true);
    }

    private Element retrieveSingleNode(Element element, String nodeName, boolean exceptionOnFail) throws IOException {
        NodeList headerElements = element.getElementsByTagName(nodeName);
        if (headerElements.getLength() == 0) {
            if (exceptionOnFail) {
                throw new IOException("A dataset must define a <" + nodeName + "> section for attribute meta data description.");
            }
            return null;
        }
        if (headerElements.getLength() > 1) {
            if (exceptionOnFail) {
                throw new IOException("A dataset must not define more than one <" + nodeName + "> section.");
            }
            return null;
        }
        return (Element)headerElements.item(0);
    }

    private Attribute createAttribute(String name, String type) {
        int valueType = 1;
        if (type.toLowerCase().equals("numeric")) {
            valueType = 2;
        } else if (type.toLowerCase().equals("real")) {
            valueType = 4;
        } else if (type.toLowerCase().equals("integer")) {
            valueType = 3;
        } else if (type.toLowerCase().equals("string")) {
            valueType = 5;
        } else if (type.toLowerCase().equals("date")) {
            valueType = 11;
        }
        return AttributeFactory.createAttribute(name, valueType);
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("data_file", "The path to the data file.", "xrff", false));
        types.add(new ParameterTypeString("id_attribute", "The (case sensitive) name of the id attribute"));
        types.add(new ParameterTypeCategory("datamanagement", "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        return types;
    }
}

