/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeRole;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XrffExampleSetWriter
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};

    public XrffExampleSetWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        try {
            File xrffFile = this.getParameterAsFile("example_set_file");
            PrintWriter out = new PrintWriter(new FileWriter(xrffFile));
            out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            out.println("<dataset name=\"YaleData\" version=\"3.5.4\">");
            out.println("  <header>");
            out.println("    <attributes>");
            Iterator<AttributeRole> a = exampleSet.getAttributes().allAttributeRoles();
            while (a.hasNext()) {
                AttributeRole role = a.next();
                if (role.getSpecialName() != null && role.getSpecialName().equals("weight")) continue;
                Attribute attribute = role.getAttribute();
                boolean label = role.getSpecialName() != null && role.getSpecialName().equals("label");
                this.printAttribute(attribute, out, label);
            }
            out.println("    </attributes>");
            out.println("  </header>");
            out.println("  <body>");
            out.println("    <instances>");
            Attribute weightAttribute = exampleSet.getAttributes().getWeight();
            for (Example example : exampleSet) {
                String weightString = "";
                if (weightAttribute != null) {
                    weightString = " weight=\"" + example.getValue(weightAttribute) + "\"";
                }
                out.println("      <instance" + weightString + ">");
                a = exampleSet.getAttributes().allAttributeRoles();
                while (a.hasNext()) {
                    AttributeRole role = a.next();
                    if (role.getSpecialName() != null && role.getSpecialName().equals("weight")) continue;
                    Attribute attribute = role.getAttribute();
                    out.println("        <value>" + example.getValueAsString(attribute) + "</value>");
                }
                out.println("      </instance>");
            }
            out.println("    </instances>");
            out.println("  </body>");
            out.println("</dataset>");
            out.close();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 303, new Object[]{this.getParameterAsString("example_set_file"), e.getMessage()});
        }
        return new IOObject[]{exampleSet};
    }

    private void printAttribute(Attribute attribute, PrintWriter out, boolean isClass) {
        String classString;
        String string = classString = isClass ? "class=\"yes\" " : "";
        if (attribute.isNominal()) {
            out.println("      <attribute name=\"" + attribute.getName() + "\" " + classString + "type=\"nominal\">");
            out.println("        <labels>");
            for (String s : attribute.getMapping().getValues()) {
                out.println("          <label>" + s + "</label>");
            }
            out.println("        </labels>");
            out.println("      </attribute>");
        } else {
            out.println("      <attribute name=\"" + attribute.getName() + "\" " + classString + "type=\"numeric\"/>");
        }
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("example_set_file", "File to save the example set to.", "xrff", false));
        return types;
    }
}

