/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.learner.weka.WekaClassifier;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.tools.WekaTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.List;
import weka.classifiers.Classifier;
import weka.core.Instances;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WekaModelLoader
extends Operator {
    public WekaModelLoader(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        File modelFile = this.getParameterAsFile("model_file");
        WekaClassifier model = null;
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(modelFile));
            Classifier classifier = (Classifier)in.readObject();
            Attribute label = null;
            try {
                Instances trainingInstances = (Instances)in.readObject();
                ExampleSet trainingExampleSet = WekaTools.toYaleExampleSet(trainingInstances);
                label = trainingExampleSet.getAttributes().getLabel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            in.close();
            model = new WekaClassifier("Weka Model", label, classifier);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 302, new Object[]{modelFile, e.getMessage()});
        }
        return new IOObject[]{model};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{Model.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("model_file", "Filename containing the Weka model to load.", "model", false));
        return types;
    }
}

