/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.postprocessing.Threshold;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThresholdWriter
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{Threshold.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{Threshold.class};

    public ThresholdWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        File thresholdFile = this.getParameterAsFile("threshold_file");
        Threshold threshold = this.getInput(Threshold.class);
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new FileWriter(thresholdFile));
                out.println("<threshold version=\"" + Yale.getVersion() + "\" value=\"" + threshold.getThreshold() + "\" first=\"" + threshold.getZeroClass() + "\" second=\"" + threshold.getOneClass() + "\"/>");
                out.close();
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, 303, new Object[]{thresholdFile, e.getMessage()});
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return new IOObject[]{threshold};
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("threshold_file", "Filename for the threshold file.", "thr", false));
        return types;
    }
}

