/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.postprocessing.Threshold;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThresholdLoader
extends Operator {
    public ThresholdLoader(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        File thresholdFile = this.getParameterAsFile("threshold_file");
        Threshold threshold = null;
        try {
            FileInputStream in = new FileInputStream(thresholdFile);
            Document document = null;
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
            }
            catch (SAXException e1) {
                throw new IOException(e1.getMessage());
            }
            catch (ParserConfigurationException e1) {
                throw new IOException(e1.getMessage());
            }
            Element thresholdElement = document.getDocumentElement();
            if (!thresholdElement.getTagName().equals("threshold")) {
                throw new IOException("Outer tag of threshold file must be <threshold>");
            }
            String thresholdValueString = thresholdElement.getAttribute("value");
            String thresholdFirst = thresholdElement.getAttribute("first");
            String thresholdSecond = thresholdElement.getAttribute("second");
            double thresholdValue = Double.parseDouble(thresholdValueString);
            threshold = new Threshold(thresholdValue, thresholdFirst, thresholdSecond);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 303, new Object[]{thresholdFile, e.getMessage()});
        }
        return new IOObject[]{threshold};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{Threshold.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("threshold_file", "Filename for the threshold file.", "thr", false));
        return types;
    }
}

