/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.SparseFormatDataRowReader;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.att.AttributeSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseFormatExampleSource
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[0];
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};

    public SparseFormatExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        int format = this.getParameterAsInt("format");
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        for (Object[] prefixMapping : this.getParameterList("prefix_map")) {
            prefixMap.put((String)prefixMapping[0], (String)prefixMapping[1]);
        }
        File dataFile = this.getParameterAsFile("data_file");
        File attributeDescriptionFile = this.getParameterAsFile("attribute_description_file");
        AttributeSet attributeSet = null;
        if (attributeDescriptionFile != null) {
            try {
                attributeSet = new AttributeSet(attributeDescriptionFile, false);
            }
            catch (Throwable e) {
                throw new UserError((Operator)this, e, 302, new Object[]{attributeDescriptionFile, e.getMessage()});
            }
            if (dataFile != null && attributeSet.getDefaultSource() != null && !dataFile.equals(attributeSet.getDefaultSource())) {
                LogService.logMessage("Attribute file names specified by parameter 'data_file' and default_source specified in '" + attributeDescriptionFile + "' do not match! Assuming the latter to be correct.", 4);
            }
            if (format != 4 && attributeSet.getSpecialAttribute("label") == null) {
                throw new UserError((Operator)this, 917, new Object[0]);
            }
            LogService.logMessage("Found " + attributeSet.getNumberOfRegularAttributes() + " regular attributes.", 0);
            dataFile = attributeSet.getDefaultSource();
        } else {
            int dimension = this.getParameterAsInt("dimension");
            if (dimension < 0) {
                throw new UserError(this, 921);
            }
            attributeSet = new AttributeSet(dimension);
            int i = 0;
            while (i < dimension) {
                Attribute attribute = AttributeFactory.createAttribute(4);
                attributeSet.addAttribute(attribute);
                ++i;
            }
            for (String specialName : prefixMap.values()) {
                attributeSet.setSpecialAttribute(specialName, AttributeFactory.createAttribute(4));
            }
            if (format != 4) {
                attributeSet.setSpecialAttribute("label", AttributeFactory.createAttribute(1));
            }
        }
        if (dataFile == null) {
            throw new UserError((Operator)this, 902, new Object[0]);
        }
        BufferedReader inData = null;
        BufferedReader inLabels = null;
        try {
            inData = Tools.getReader(dataFile);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 302, new Object[]{dataFile, e.getMessage()});
        }
        File labelFile = null;
        if (format == 3) {
            labelFile = this.getParameterAsFile("label_file");
            if (labelFile == null) {
                throw new UserError((Operator)this, 201, new Object[]{"format", SparseFormatDataRowReader.FORMAT_NAMES[3], "label_file"});
            }
            try {
                inLabels = Tools.getReader(labelFile);
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, 302, new Object[]{labelFile, e.getMessage()});
            }
        }
        MemoryExampleTable table = new MemoryExampleTable(attributeSet.getAllAttributes());
        SparseFormatDataRowReader reader = new SparseFormatDataRowReader(new DataRowFactory(this.getParameterAsInt("datamanagement"), this.getParameterAsString("decimal_point_character").charAt(0)), format, prefixMap, attributeSet, inData, inLabels, this.getParameterAsInt("sample_size"));
        table.readExamples(reader);
        ExampleSet exampleSet = table.createExampleSet(attributeSet);
        return new IOObject[]{exampleSet};
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory("format", "Format of the sparse data file.", SparseFormatDataRowReader.FORMAT_NAMES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeFile("attribute_description_file", "Name of the attribute description file.", "aml", true);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeFile("data_file", "Name of the data file. Only necessary if not specified in the attribute description file.", null, true));
        types.add(new ParameterTypeFile("label_file", "Name of the data file containing the labels. Only necessary if format is 'format_separate_file'.", null, true));
        types.add(new ParameterTypeInt("dimension", "Dimension of the example space. Only necessary if parameter 'attribute_description_file' is not set.", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeInt("sample_size", "The maximum number of examples to read from the data files (-1 = all)", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeCategory("datamanagement", "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 5));
        types.add(new ParameterTypeString("decimal_point_character", "Character that is used as decimal point.", "."));
        types.add(new ParameterTypeList("prefix_map", "Maps prefixes to names of special attributes.", new ParameterTypeString("special_attribute", "Maps prefixes to names of special attributes.")));
        return types;
    }
}

