/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.FileDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.RandomGenerator;
import edu.udo.cs.yale.tools.att.AttributeDataSource;
import edu.udo.cs.yale.tools.att.AttributeDataSourceCreator;
import edu.udo.cs.yale.tools.att.AttributeDataSources;
import edu.udo.cs.yale.tools.att.AttributeSet;
import java.io.File;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleExampleSource
extends Operator {
    protected static final String PARAMETER_FILE_NAME = "filename";
    protected static final String PARAMETER_ATTRIBUTE_NAMES = "read_attribute_names";
    protected static final String PARAMETER_USE_QUOTES = "use_quotes";
    protected static final String PARAMETER_COLUMN_SEPARATORS = "column_separators";

    public SimpleExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        File file = this.getParameterAsFile(PARAMETER_FILE_NAME);
        double sampleRatio = this.getParameterAsDouble("sample_ratio");
        int maxLines = this.getParameterAsInt("sample_size");
        String separatorRegExpr = this.getParameterAsString(PARAMETER_COLUMN_SEPARATORS);
        char[] comments = this.getParameterAsString("comment_chars").toCharArray();
        int dataRowType = this.getParameterAsInt("datamanagement");
        boolean useQuotes = this.getParameterAsBoolean(PARAMETER_USE_QUOTES);
        char decimalPointCharacter = this.getParameterAsString("decimal_point_character").charAt(0);
        AttributeDataSourceCreator adsCreator = new AttributeDataSourceCreator();
        try {
            adsCreator.loadData(file, comments, separatorRegExpr, useQuotes, this.getParameterAsBoolean(PARAMETER_ATTRIBUTE_NAMES), -1);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 302, file, (Object)e.getMessage());
        }
        List<AttributeDataSource> attributeDataSources = adsCreator.getAttributeDataSources();
        this.resetAttributeType(attributeDataSources, "label_name", "label_column", "label");
        this.resetAttributeType(attributeDataSources, "id_name", "id_column", "id");
        this.resetAttributeType(attributeDataSources, "weight_name", "weight_column", "weight");
        FileDataRowReader reader = null;
        try {
            reader = new FileDataRowReader(new DataRowFactory(dataRowType, decimalPointCharacter), attributeDataSources, sampleRatio, maxLines, separatorRegExpr, comments, useQuotes, RandomGenerator.getRandomGenerator(-1));
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 302, new Object[]{file, e.getMessage()});
        }
        if (this.getParameterAsBoolean(PARAMETER_ATTRIBUTE_NAMES)) {
            reader.skipLine();
        }
        AttributeSet attributeSet = new AttributeSet(new AttributeDataSources(attributeDataSources, file));
        MemoryExampleTable table = new MemoryExampleTable(attributeSet.getAllAttributes(), reader);
        ExampleSet result = table.createExampleSet(attributeSet);
        return new IOObject[]{result};
    }

    private void resetAttributeType(List<AttributeDataSource> attributeDataSources, String attributeName, String columnName, String typeName) throws OperatorException {
        block4: {
            String attribute;
            block3: {
                attribute = this.getParameterAsString(attributeName);
                if (attribute != null && attribute.length() != 0) break block3;
                int column = this.getParameterAsInt(columnName);
                if (column == 0) break block4;
                if (column < 0) {
                    column = attributeDataSources.size() + column + 1;
                }
                if (column < 1 || column >= attributeDataSources.size() + 1) {
                    throw new UserError((Operator)this, 111, String.valueOf(columnName) + " = " + column);
                }
                attributeDataSources.get(--column).setType(typeName);
                break block4;
            }
            for (AttributeDataSource ads : attributeDataSources) {
                if (!ads.getAttribute().getName().equals(attribute)) continue;
                ads.setType(typeName);
                break;
            }
        }
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_FILE_NAME, "Name of the file to read the data from.", "dat", false));
        ParameterTypeSingle type = new ParameterTypeBoolean(PARAMETER_ATTRIBUTE_NAMES, "Read attribute names from file (assumes the attribute names are in the first line of the file).", false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeString("label_name", "Name of the label attribute (if empty, the column defined by label_column will be used)", true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("label_column", "Column number of the label attribute (only used if label_name is empty; 0 = none; negative values are counted from the last column)", Integer.MIN_VALUE, Integer.MAX_VALUE, 0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString("id_name", "Name of the id attribute (if empty, the column defined by id_column will be used)", true));
        types.add(new ParameterTypeInt("id_column", "Column number of the id attribute (only used if id_name is empty; 0 = none; negative values are counted from the last column)", Integer.MIN_VALUE, Integer.MAX_VALUE, 0));
        types.add(new ParameterTypeString("weight_name", "Name of the weight attribute (if empty, the column defined by weight_column will be used)", true));
        types.add(new ParameterTypeInt("weight_column", "Column number of the weight attribute (only used if weight_name is empty; 0 = none, negative values are counted from the last column)", Integer.MIN_VALUE, Integer.MAX_VALUE, 0));
        type = new ParameterTypeDouble("sample_ratio", "The fraction of the data set which should be read (1 = all; only used if sample_size = -1)", 0.0, 1.0, 1.0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt("sample_size", "The exact number of samples which should be read (-1 = use sample ratio; if not -1, sample_ratio will not have any effect)", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeCategory("datamanagement", "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        types.add(new ParameterTypeString(PARAMETER_COLUMN_SEPARATORS, "Column separators for data files (regular expression)", ",\\s*|;\\s*|\\s+"));
        types.add(new ParameterTypeString("comment_chars", "Lines beginning with these characters are ignored.", "#"));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_QUOTES, "Indicates if quotes should be regarded (slower!).", false));
        types.add(new ParameterTypeString("decimal_point_character", "Character that is used as decimal point.", "."));
        return types;
    }
}

