/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SPSSDataRowReader;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import java.io.File;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPSSExampleSource
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[0];
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};

    public SPSSExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        SPSSDataRowReader reader = null;
        File file = this.getParameterAsFile("filename");
        try {
            reader = new SPSSDataRowReader(new DataRowFactory(this.getParameterAsInt("datamanagement")), file, this.getParameterAsInt("attribute_naming_mode"), this.getParameterAsBoolean("use_value_labels"), this.getParameterAsBoolean("recode_user_missings"), this.getParameterAsDouble("sample_ratio"), this.getParameterAsInt("sample_size"));
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 302, file, (Object)e.getMessage());
        }
        ExampleSet result = reader.getExampleSet();
        if (result.size() == 0) {
            throw new UserError(this, 117);
        }
        return new IOObject[]{result};
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("filename", "Name of the file to read the data from.", "sav", false));
        types.add(new ParameterTypeCategory("attribute_naming_mode", "Determines which SPSS variable properties should be used for attribute naming.", SPSSDataRowReader.ATTRIBUTE_NAMING_MODES, 0));
        types.add(new ParameterTypeBoolean("use_value_labels", "Use SPSS value labels as values.", false));
        types.add(new ParameterTypeBoolean("recode_user_missings", "Recode SPSS user missings to missing values.", true));
        types.add(new ParameterTypeDouble("sample_ratio", "The fraction of the data set which should be read (1 = all; only used if sample_size = -1)", 0.0, 1.0, 1.0));
        types.add(new ParameterTypeInt("sample_size", "The exact number of samples which should be read (-1 = all; if not -1, sample_ratio will not have any effect)", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeCategory("datamanagement", "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        return types;
    }
}

