/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.ResultObject;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.tools.ResultService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultWriter
extends Operator {
    private boolean firstRun = true;

    public ResultWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        IOObject[] input = this.getInput().getIOObjects();
        File file = this.getParameterAsFile("result_file");
        if (file != null) {
            PrintStream out = null;
            try {
                out = this.firstRun ? new PrintStream(new FileOutputStream(file, false)) : new PrintStream(new FileOutputStream(file, true));
                this.firstRun = false;
            }
            catch (FileNotFoundException e) {
                throw new UserError((Operator)this, 301, file);
            }
            if (out != null) {
                ResultService.logResult("Results of ResultWriter '" + this.getName() + "' [" + this.getApplyCount() + "]: ", out);
                int i = 0;
                while (i < input.length) {
                    if (input[i] instanceof ResultObject) {
                        ResultService.logResult((ResultObject)input[i], out);
                    }
                    ++i;
                }
                out.close();
            }
        } else {
            ResultService.logResult("Results of ResultWriter '" + this.getName() + "' [" + this.getApplyCount() + "]: ");
            int i = 0;
            while (i < input.length) {
                if (input[i] instanceof ResultObject) {
                    ResultService.logResult((ResultObject)input[i]);
                }
                ++i;
            }
        }
        return new IOObject[0];
    }

    @Override
    public void experimentStarts() throws OperatorException {
        super.experimentStarts();
        this.firstRun = true;
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeFile type = new ParameterTypeFile("result_file", "Appends the descriptions of the input objects to this file. If empty, use the general file defined in the experiment root operator.", ".res", true);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

