/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.ResultSetDataRowReader;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.jdbc.DatabaseHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResultSetExampleSource
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[0];
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};

    public ResultSetExampleSource(OperatorDescription description) {
        super(description);
    }

    public abstract ResultSet getResultSet() throws OperatorException;

    public abstract void setNominalValues(List var1, ResultSet var2, Attribute var3) throws OperatorException;

    @Override
    public IOObject[] apply() throws OperatorException {
        int dataRowType = this.getParameterAsInt("datamanagement");
        ResultSet resultSet = this.getResultSet();
        List<Attribute> attributeList = null;
        try {
            attributeList = DatabaseHandler.createAttributes(resultSet);
        }
        catch (SQLException e) {
            throw new UserError((Operator)this, (Throwable)e, 304, (Object)e.getMessage());
        }
        this.setNominalValues(attributeList, resultSet, ResultSetExampleSource.find(attributeList, this.getParameterAsString("label_attribute")));
        ResultSetDataRowReader reader = new ResultSetDataRowReader(new DataRowFactory(dataRowType), attributeList, resultSet);
        MemoryExampleTable table = new MemoryExampleTable(attributeList, reader);
        return new IOObject[]{this.createExampleSet(table)};
    }

    private static Attribute find(List attributeList, String name) throws OperatorException {
        if (name == null) {
            return null;
        }
        for (Attribute attribute : attributeList) {
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        throw new UserError(null, 111, name);
    }

    protected ExampleSet createExampleSet(ExampleTable table) throws OperatorException {
        String labelName = this.getParameterAsString("label_attribute");
        String weightName = this.getParameterAsString("weight_attribute");
        String idName = this.getParameterAsString("id_attribute");
        Attribute label = table.findAttribute(labelName);
        Attribute weight = table.findAttribute(weightName);
        Attribute id = table.findAttribute(idName);
        HashMap<Attribute, String> specialMap = new HashMap<Attribute, String>();
        specialMap.put(label, "label");
        specialMap.put(weight, "weight");
        specialMap.put(id, "id");
        return table.createExampleSet(specialMap);
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeString type = new ParameterTypeString("label_attribute", "The (case sensitive) name of the label attribute");
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString("id_attribute", "The (case sensitive) name of the id attribute"));
        types.add(new ParameterTypeString("weight_attribute", "The (case sensitive) name of the weight attribute"));
        types.add(new ParameterTypeCategory("datamanagement", "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        return types;
    }
}

