/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.meta.ParameterSet;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterSetWriter
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{ParameterSet.class};

    public ParameterSetWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ParameterSet parameterSet = this.getInput(ParameterSet.class);
        File parameterFile = this.getParameterAsFile("parameter_file");
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new FileWriter(parameterFile));
                parameterSet.writeParameterSet(out);
            }
            catch (IOException e) {
                throw new UserError((Operator)this, 303, e, (Object)new Object[]{parameterFile, e.getMessage()});
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return new IOObject[]{parameterSet};
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("parameter_file", "A file containing a parameter set.", "par", false));
        return types;
    }
}

