/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.meta.ParameterSet;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterSetLoader
extends Operator {
    private static final Class[] OUTPUT_CLASSES = new Class[]{ParameterSet.class};

    public ParameterSetLoader(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ParameterSet parameterSet = null;
        File parameterFile = this.getParameterAsFile("parameter_file");
        try {
            FileInputStream in = new FileInputStream(parameterFile);
            parameterSet = ParameterSet.readParameterSet(in);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 302, e, (Object)new Object[]{parameterFile, e.getMessage()});
        }
        return new IOObject[]{parameterSet};
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("parameter_file", "A file containing a parameter set.", "par", false));
        return types;
    }
}

