/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelWriter
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{Model.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{Model.class};

    public ModelWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        File modelFile = this.getParameterAsFile("model_file");
        Model model = this.getInput(Model.class);
        try {
            if (!this.getParameterAsBoolean("overwrite_existing_file") && modelFile.exists()) {
                File newFile = null;
                String fileName = modelFile.getAbsolutePath();
                int counter = 1;
                while (true) {
                    String[] extension = fileName.split("\\.");
                    int n = extension.length - 2;
                    extension[n] = String.valueOf(extension[n]) + "_" + counter + ".";
                    String newFileName = this.stringArrayToString(extension);
                    newFile = new File(newFileName);
                    if (!newFile.exists()) break;
                    ++counter;
                }
                modelFile = newFile;
            }
            OutputStream out = null;
            out = this.getParameterAsBoolean("zip_output") ? new GZIPOutputStream(new FileOutputStream(modelFile)) : new FileOutputStream(modelFile);
            model.write(out);
            out.close();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 303, new Object[]{modelFile, e.getMessage()});
        }
        return new IOObject[]{model};
    }

    private String stringArrayToString(String[] filenameParts) {
        StringBuffer newString = new StringBuffer();
        int i = 0;
        while (i < filenameParts.length) {
            newString.append(filenameParts[i]);
            ++i;
        }
        return newString.toString();
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("model_file", "Filename for the model file.", "mod", false));
        types.add(new ParameterTypeBoolean("overwrite_existing_file", "Overwrite an existing file. If set to false then an index is appended to the filename.", true));
        types.add(new ParameterTypeBoolean("zip_output", "Indicates if the output should be zipped.", true));
        return types;
    }
}

