/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.operator.AbstractIOObject;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelLoader
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[0];
    private static final Class[] OUTPUT_CLASSES = new Class[]{Model.class};

    public ModelLoader(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        File modelFile = this.getParameterAsFile("model_file");
        Model model = null;
        InputStream in = null;
        try {
            in = new GZIPInputStream(new FileInputStream(modelFile));
        }
        catch (IOException e1) {
            try {
                in = new FileInputStream(modelFile);
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, 302, new Object[]{modelFile, e.getMessage()});
            }
        }
        try {
            model = (Model)AbstractIOObject.read(in);
            in.close();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 302, new Object[]{modelFile, e.getMessage()});
        }
        return new IOObject[]{model};
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("model_file", "Filename containing the model to load.", "mod", false));
        return types;
    }
}

