/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.io.ResultSetExampleSource;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.tools.LogService;
import java.io.File;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.List;
import org.kobjects.jdbc.TableManager;
import org.kobjects.jdbc.util.AbstractResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KDBExampleSource
extends ResultSetExampleSource {
    public abstract String getFormat();

    public abstract String getExtension();

    public KDBExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public ResultSet getResultSet() throws UndefinedParameterError {
        File dataFile = this.getParameterAsFile("data_file");
        String dataFileAbsolutePath = dataFile.getAbsolutePath();
        return TableManager.getResultSet((String)(String.valueOf(this.getFormat()) + ":" + dataFileAbsolutePath), (int)1);
    }

    @Override
    public void setNominalValues(List attributeList, ResultSet resultSet, Attribute label) throws OperatorException {
        if (resultSet instanceof AbstractResultSet) {
            AbstractResultSet ars = (AbstractResultSet)resultSet;
            Iterator i = attributeList.iterator();
            int j = 0;
            while (i.hasNext()) {
                Attribute attribute = (Attribute)i.next();
                Object[] values = ars.getColumnSet().getColumn(++j).getValues();
                if (!attribute.isNominal()) continue;
                if (values == null) {
                    LogService.logMessage("Information about class values is null!", 4);
                    continue;
                }
                int k = 0;
                while (k < values.length) {
                    attribute.getMapping().mapString(values[k].toString());
                    ++k;
                }
            }
        } else {
            LogService.logMessage("Result set does not provide information about class values!", 4);
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("data_file", "The file containing the data", this.getExtension(), false));
        return types;
    }
}

