/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.XMLSerialization;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOContainerWriter
extends Operator {
    public IOContainerWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        IOContainer input = this.getInput();
        File file = this.getParameterAsFile("filename");
        try {
            OutputStream out = null;
            out = this.getParameterAsBoolean("zipped") ? new GZIPOutputStream(new FileOutputStream(file)) : new FileOutputStream(file);
            XMLSerialization.getXMLSerialization().writeXML(input, out);
            out.close();
            LogService.logMessage(String.valueOf(this.getName()) + ": Input IOContainer written to file" + file, 2);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 303, new Object[]{file, e.getMessage()});
        }
        return new IOObject[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeFile type = new ParameterTypeFile("filename", "Name of file to write the output to.", "ioc", false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean("zipped", "Indicates if the file content should be zipped.", true));
        return types;
    }
}

