/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.XMLSerialization;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOContainerReader
extends Operator {
    public static final String[] METHODS = new String[]{"append", "prepend", "replace"};
    public static final int APPEND = 0;
    public static final int PREPEND = 1;
    public static final int REPLACE = 2;

    public IOContainerReader(OperatorDescription description) {
        super(description);
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        InputStream in;
        IOContainer input = this.getInput();
        File file = this.getParameterAsFile("filename");
        try {
            in = new GZIPInputStream(new FileInputStream(file));
        }
        catch (IOException e1) {
            try {
                in = new FileInputStream(file);
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, 302, new Object[]{file, e.getMessage()});
            }
        }
        IOContainer content = null;
        try {
            content = (IOContainer)XMLSerialization.getXMLSerialization().fromXML(in);
            in.close();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 302, new Object[]{file, e.getMessage()});
        }
        switch (this.getParameterAsInt("method")) {
            case 0: {
                content = content.append(input.getIOObjects());
                break;
            }
            case 1: {
                content = content.prepend(input.getIOObjects());
            }
        }
        if (this.getParameterAsString("logfile") != null) {
            try {
                BufferedReader logIn = new BufferedReader(new FileReader(this.getParameterAsFile("logfile")));
                String line = null;
                while ((line = logIn.readLine()) != null) {
                    LogService.logMessage(line, 2);
                }
                logIn.close();
            }
            catch (Exception e) {
                LogService.logMessage("Could not read from logfile: " + e.toString(), 4);
            }
        }
        return content.getIOObjects();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeFile("filename", "Name of file to write the output to.", "ioc", false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory("method", "Append or prepend the contents of the file to this operators input or replace this operators input?", METHODS, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeFile("logfile", "Name of file to read log information from (optional).", "log", true);
        types.add(type);
        return types;
    }
}

