/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.datatable.GnuPlotDataTableHandler;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GNUPlotOperator
extends Operator {
    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[0];
    }

    public GNUPlotOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        String dataTableName = this.getParameterAsString("name");
        if (!this.getExperiment().dataTableExists(dataTableName)) {
            LogService.logMessage("Data table with name '" + dataTableName + "' does not exist.", 6);
            return new IOObject[0];
        }
        DataTable dataTable = this.getExperiment().getDataTable(dataTableName);
        String[] valueNames = this.getParameterAsString("values").split(" ");
        int[] values = new int[valueNames.length];
        int i = 0;
        while (i < values.length) {
            values[i] = dataTable.getColumnIndex(valueNames[i]);
            if (values[i] == -1) {
                LogService.logMessage(String.valueOf(this.getName()) + ": No data column with name '" + valueNames[i] + "' exists.", 6);
                return new IOObject[0];
            }
            ++i;
        }
        String xAxisName = this.getParameterAsString("x_axis");
        int xAxis = dataTable.getColumnIndex(xAxisName);
        if (xAxis == -1) {
            LogService.logMessage("No data column with name '" + xAxisName + "' exists.", 6);
            return new IOObject[0];
        }
        String yAxisName = this.getParameterAsString("y_axis");
        int yAxis = -1;
        if (yAxisName != null && (yAxis = dataTable.getColumnIndex(yAxisName)) == -1) {
            LogService.logMessage("No data column with name '" + yAxisName + "' exists.", 6);
            return new IOObject[0];
        }
        String additional = "";
        if (this.isParameterSet("title")) {
            additional = String.valueOf(additional) + "set title \"" + this.getParameterAsString("title") + "\"" + Tools.getLineSeparator();
        }
        if (this.isParameterSet("additional_parameters")) {
            additional = String.valueOf(additional) + this.getParameterAsString("additional_parameters");
        }
        try {
            File file = this.getParameterAsFile("output_file");
            LogService.logMessage("Creating gnuplot file '" + file + "'", 0);
            PrintStream out = new PrintStream(new FileOutputStream(file));
            GnuPlotDataTableHandler handler = new GnuPlotDataTableHandler(dataTable);
            handler.writeGNUPlot(out, xAxis, yAxis, values, "linespoints", additional, null);
            out.close();
        }
        catch (IOException e) {
            LogService.logMessage("Cannot create output file: " + e.getMessage(), 6);
            return new IOObject[0];
        }
        return new IOObject[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("output_file", "The gnuplot file.", "gnu", false));
        types.add(new ParameterTypeString("name", "The name of the experiment log operator which produced the data table.", false));
        types.add(new ParameterTypeString("title", "The title of the plot.", "Created by Yale"));
        types.add(new ParameterTypeString("x_axis", "The values of the x-axis.", false));
        ParameterTypeString type = new ParameterTypeString("y_axis", "The values of the y-axis (for 3d plots).", true);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString("values", "A whitespace separated list of values which should be plotted.", false));
        types.add(new ParameterTypeString("additional_parameters", "Additional parameters for the gnuplot header.", true));
        return types;
    }
}

