/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.tools.att.AttributeDataSourceCreator;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelExampleSource
extends Operator {
    public ExcelExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        Cell cell;
        File file = this.getParameterAsFile("excel_file");
        Workbook workbook = null;
        try {
            workbook = Workbook.getWorkbook((File)file);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, 302, file, (Object)e.getMessage());
        }
        Sheet sheet = workbook.getSheet(this.getParameterAsInt("sheet_number"));
        int numberOfColumns = sheet.getColumns();
        int numberOfRows = sheet.getRows();
        int rowOffset = 0;
        int columnOffset = 0;
        boolean contentFound = false;
        int r = 0;
        while (r < numberOfRows) {
            int c = 0;
            while (c < numberOfColumns) {
                Cell cell2 = sheet.getCell(c, r);
                String content = cell2.getContents();
                if (content != null && content.trim().length() > 0) {
                    columnOffset = c;
                    contentFound = true;
                    break;
                }
                ++c;
            }
            if (contentFound) {
                rowOffset = r;
                break;
            }
            ++r;
        }
        if (!contentFound) {
            throw new UserError((Operator)this, 302, file, (Object)"spreadsheet seems to be empty");
        }
        TreeSet<Integer> emptyRows = new TreeSet<Integer>();
        int r2 = rowOffset;
        while (r2 < numberOfRows) {
            boolean rowEmpty = true;
            int c = columnOffset;
            while (c < numberOfColumns) {
                Cell cell3 = sheet.getCell(c, r2);
                String content = cell3.getContents();
                if (content != null && content.trim().length() > 0) {
                    rowEmpty = false;
                    break;
                }
                ++c;
            }
            if (rowEmpty) {
                emptyRows.add(r2);
            }
            ++r2;
        }
        TreeSet<Integer> emptyColumns = new TreeSet<Integer>();
        int c = columnOffset;
        while (c < numberOfColumns) {
            boolean columnEmpty = true;
            int r3 = rowOffset;
            while (r3 < numberOfRows) {
                cell = sheet.getCell(c, r3);
                String content = cell.getContents();
                if (content != null && content.trim().length() > 0) {
                    columnEmpty = false;
                    break;
                }
                ++r3;
            }
            if (columnEmpty) {
                emptyColumns.add(c);
            }
            ++c;
        }
        String[] attributeNames = new String[numberOfColumns - columnOffset - emptyColumns.size()];
        if (this.getParameterAsBoolean("first_row_as_names")) {
            int columnCounter = 0;
            int c2 = columnOffset;
            while (c2 < numberOfColumns) {
                if (!emptyColumns.contains(c2)) {
                    cell = sheet.getCell(c2, rowOffset);
                    attributeNames[columnCounter++] = cell.getContents();
                }
                ++c2;
            }
        } else {
            int c3 = 0;
            while (c3 < numberOfColumns - columnOffset - emptyColumns.size()) {
                attributeNames[c3] = String.valueOf(file.getName()) + " (" + (c3 + 1) + ")";
                ++c3;
            }
        }
        int[] valueTypes = new int[numberOfColumns - columnOffset - emptyColumns.size()];
        int i = 0;
        while (i < valueTypes.length) {
            valueTypes[i] = 3;
            ++i;
        }
        int r4 = rowOffset;
        while (r4 < numberOfRows) {
            if (!(r4 == rowOffset && this.getParameterAsBoolean("first_row_as_names") || emptyRows.contains(r4))) {
                String[] row = new String[numberOfColumns - columnOffset - emptyColumns.size()];
                int columnCounter = 0;
                int c4 = columnOffset;
                while (c4 < numberOfColumns) {
                    if (!emptyColumns.contains(c4)) {
                        Cell cell4 = sheet.getCell(c4, r4);
                        row[columnCounter] = cell4.getContents();
                        if (row[columnCounter] == null || row[columnCounter].trim().length() == 0) {
                            row[columnCounter] = "?";
                        }
                        ++columnCounter;
                    }
                    ++c4;
                }
                AttributeDataSourceCreator.guessValueTypes(row, valueTypes);
            }
            ++r4;
        }
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        int c5 = 0;
        while (c5 < numberOfColumns - columnOffset - emptyColumns.size()) {
            attributes.add(AttributeFactory.createAttribute(attributeNames[c5], valueTypes[c5]));
            ++c5;
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        DataRowFactory dataRowFactory = new DataRowFactory(this.getParameterAsInt("datamanagement"));
        Attribute[] attributeArray = new Attribute[attributes.size()];
        attributes.toArray(attributeArray);
        int r5 = rowOffset;
        while (r5 < numberOfRows) {
            if (!(r5 == rowOffset && this.getParameterAsBoolean("first_row_as_names") || emptyRows.contains(r5))) {
                String[] row = new String[numberOfColumns - columnOffset - emptyColumns.size()];
                int columnCounter = 0;
                int c6 = columnOffset;
                while (c6 < numberOfColumns) {
                    if (!emptyColumns.contains(c6)) {
                        Cell cell5 = sheet.getCell(c6, r5);
                        row[columnCounter] = cell5.getContents();
                        if (row[columnCounter] == null || row[columnCounter].trim().length() == 0) {
                            row[columnCounter] = "?";
                        }
                        ++columnCounter;
                    }
                    ++c6;
                }
                DataRow dataRow = dataRowFactory.create(row, attributeArray);
                table.addDataRow(dataRow);
                this.checkForStop();
            }
            ++r5;
        }
        Attribute labelAttribute = null;
        int labelColumn = this.getParameterAsInt("label_column");
        if (labelColumn != 0) {
            if (labelColumn >= attributes.size() + 1) {
                throw new UserError((Operator)this, 111, "label_column = " + labelColumn);
            }
            labelAttribute = attributeArray[labelColumn - 1];
        }
        Attribute idAttribute = null;
        int idColumn = this.getParameterAsInt("id_column");
        if (idColumn != 0) {
            if (idColumn >= attributes.size() + 1) {
                throw new UserError((Operator)this, 111, "id_column = " + idColumn);
            }
            idAttribute = attributeArray[idColumn - 1];
        }
        HashMap<Attribute, String> specialMap = new HashMap<Attribute, String>();
        specialMap.put(labelAttribute, "label");
        specialMap.put(idAttribute, "id");
        ExampleSet exampleSet = table.createExampleSet(specialMap);
        return new IOObject[]{exampleSet};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("excel_file", "The Excel spreadsheet file which should be loaded.", "xls", false));
        types.add(new ParameterTypeInt("sheet_number", "The number of the sheet which should be imported.", 0, Integer.MAX_VALUE, 0));
        ParameterTypeSingle type = new ParameterTypeBoolean("first_row_as_names", "Indicates if the first row should be used for the attribute names.", false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("label_column", "Indicates which column should be used for the label attribute (0: no label)", 0, Integer.MAX_VALUE, 0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt("id_column", "Indicates which column should be used for the Id attribute (0: no id)", 0, Integer.MAX_VALUE, 0));
        types.add(new ParameterTypeCategory("datamanagement", "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        return types;
    }
}

