/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.FileDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.gui.wizards.ExampleSourceConfigurationWizardCreator;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeAttributeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeConfiguration;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.RandomGenerator;
import edu.udo.cs.yale.tools.XMLException;
import edu.udo.cs.yale.tools.att.AttributeDataSource;
import edu.udo.cs.yale.tools.att.AttributeDataSources;
import edu.udo.cs.yale.tools.att.AttributeSet;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleSource
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[0];
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};

    public ExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        AttributeDataSources attributeDataSources = null;
        FileDataRowReader reader = null;
        File attributeFile = this.getParameterAsFile("attributes");
        try {
            attributeDataSources = AttributeDataSource.createAttributeDataSources(attributeFile, true);
            reader = new FileDataRowReader(new DataRowFactory(this.getParameterAsInt("datamanagement"), this.getParameterAsString("decimal_point_character").charAt(0)), attributeDataSources.getDataSources(), this.getParameterAsDouble("sample_ratio"), this.getParameterAsInt("sample_size"), this.getParameterAsString("column_separators"), this.getParameterAsString("comment_chars").toCharArray(), this.getParameterAsBoolean("use_quotes"), RandomGenerator.getRandomGenerator(this.getParameterAsInt("local_random_seed")));
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 302, new Object[]{attributeFile, e.getMessage()});
        }
        catch (XMLException e) {
            throw new UserError((Operator)this, (Throwable)e, 401, (Object)e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new UserError((Operator)this, (Throwable)e, 401, (Object)e.toString());
        }
        catch (SAXException e) {
            throw new UserError((Operator)this, (Throwable)e, 401, (Object)e.toString());
        }
        AttributeSet attributeSet = new AttributeSet(attributeDataSources);
        MemoryExampleTable table = new MemoryExampleTable(attributeSet.getAllAttributes(), reader, this.getParameterAsBoolean("permutate"));
        ExampleSet result = table.createExampleSet(attributeSet);
        if (result.size() == 0) {
            throw new UserError(this, 117);
        }
        return new IOObject[]{result};
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterType type = new ParameterTypeConfiguration(ExampleSourceConfigurationWizardCreator.class, this);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeAttributeFile("attributes", "Filename for the xml attribute description file. This file also contains the names of the files to read the data from.", false));
        type = new ParameterTypeDouble("sample_ratio", "The fraction of the data set which should be read (1 = all; only used if sample_size = -1)", 0.0, 1.0, 1.0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt("sample_size", "The exact number of samples which should be read (-1 = use sample ratio; if not -1, sample_ratio will not have any effect)", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeCategory("datamanagement", "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        types.add(new ParameterTypeString("column_separators", "Column separators for data files (regular expression)", ",\\s*|;\\s*|\\s+"));
        types.add(new ParameterTypeString("comment_chars", "Lines beginning with these characters are ignored.", "#"));
        types.add(new ParameterTypeString("decimal_point_character", "Character that is used as decimal point.", "."));
        types.add(new ParameterTypeBoolean("use_quotes", "Indicates if quotes should be regarded (slower!).", false));
        types.add(new ParameterTypeBoolean("permutate", "Indicates if the loaded data should be permutated.", false));
        types.add(new ParameterTypeInt("local_random_seed", "Use the given random seed instead of global random numbers (only for permutation, -1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

