/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleFormatter;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.FormatterException;
import edu.udo.cs.yale.example.SparseFormatDataRowReader;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleSetWriter
extends Operator {
    private static String[] formatNames = new String[SparseFormatDataRowReader.FORMAT_NAMES.length + 2];
    private static final int DENSE_FORMAT = 0;

    static {
        ExampleSetWriter.formatNames[0] = "dense";
        int i = 0;
        while (i < SparseFormatDataRowReader.FORMAT_NAMES.length) {
            ExampleSetWriter.formatNames[i + 1] = "sparse_" + SparseFormatDataRowReader.FORMAT_NAMES[i];
            ++i;
        }
        ExampleSetWriter.formatNames[ExampleSetWriter.formatNames.length - 1] = "special_format";
    }

    public ExampleSetWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet eSet = this.getInput(ExampleSet.class);
        boolean zipped = this.getParameterAsBoolean("zipped");
        File dataFile = this.getParameterAsFile("example_set_file");
        if (zipped) {
            dataFile = new File(String.valueOf(dataFile.getAbsolutePath()) + ".gz");
        }
        File attFile = this.getParameterAsFile("attribute_description_file");
        int fractionDigits = this.getParameterAsInt("fraction_digits");
        boolean append = this.getParameterAsBoolean("append");
        try {
            int format = this.getParameterAsInt("format");
            this.logMessage("Writing example set in format '" + formatNames[format] + "'.", 2);
            if (format == 0) {
                eSet.writeDataFile(dataFile, fractionDigits, zipped, append);
                if (attFile != null) {
                    eSet.writeAttributeFile(attFile, dataFile);
                }
            } else if (format == formatNames.length - 1) {
                if (attFile != null) {
                    this.logMessage("special_format used. Ignoring attribute description file.", 6);
                }
                this.writeSpecialFormat(eSet, dataFile, fractionDigits, zipped, append);
            } else {
                eSet.writeSparseDataFile(dataFile, format - 1, fractionDigits, zipped, append);
                if (attFile != null) {
                    eSet.writeSparseAttributeFile(attFile, dataFile, format - 1);
                }
            }
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 303, new Object[]{dataFile + " / " + attFile, e.getMessage()});
        }
        return new IOObject[]{eSet};
    }

    private void writeSpecialFormat(ExampleSet exampleSet, File dataFile, int fractionDigits, boolean zipped, boolean append) throws OperatorException {
        ExampleFormatter formatter;
        String format = this.getParameterAsString("special_format");
        if (format == null) {
            throw new UserError((Operator)this, 201, new Object[]{"special_format", "format", "special_format"});
        }
        try {
            formatter = ExampleFormatter.compile(format, exampleSet, fractionDigits);
        }
        catch (FormatterException e) {
            throw new UserError((Operator)this, 901, format, (Object)e.getMessage());
        }
        try {
            OutputStream out = null;
            out = zipped ? new GZIPOutputStream(new FileOutputStream(dataFile, append)) : new FileOutputStream(dataFile, append);
            PrintWriter writer = new PrintWriter(out);
            Iterator reader = exampleSet.iterator();
            while (reader.hasNext()) {
                writer.println(formatter.format((Example)reader.next()));
            }
            writer.close();
            out.close();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 303, dataFile, (Object)e.getMessage());
        }
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("example_set_file", "File to save the example set to.", "dat", false));
        types.add(new ParameterTypeFile("attribute_description_file", "File to save the attribute descriptions to.", "aml", true));
        types.add(new ParameterTypeCategory("format", "Format to use for output.", formatNames, 0));
        types.add(new ParameterTypeString("special_format", "Format string to use for output.", true));
        types.add(new ParameterTypeInt("fraction_digits", "The number of fraction digits in the output file.", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeBoolean("zipped", "Indicates if the data file content should be zipped.", false));
        types.add(new ParameterTypeBoolean("append", "Indicates if the data should be appended to an possible existing data file. Otherwise the existing file will be overwritten.", false));
        return types;
    }
}

