/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DatabaseExampleTable;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.wizards.DBExampleSourceConfigurationWizardCreator;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.io.ResultSetExampleSource;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeConfiguration;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypePassword;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.parameter.ParameterTypeText;
import edu.udo.cs.yale.operator.parameter.TextType;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.jdbc.DatabaseHandler;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseExampleSource
extends ResultSetExampleSource {
    private DatabaseHandler dbAccess;

    public DatabaseExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public void setNominalValues(List attributeList, ResultSet resultSet, Attribute label) throws UndefinedParameterError {
        this.setNominalValuesForLabel(label);
    }

    private void setNominalValuesForLabel(Attribute label) throws UndefinedParameterError {
        if (label != null) {
            String classes = this.getParameterAsString("classes");
            if (label.isNominal()) {
                if (classes != null) {
                    String[] labelClasses = classes.split(" ");
                    int i = 0;
                    while (i < labelClasses.length) {
                        label.getMapping().mapString(labelClasses[i].trim());
                        ++i;
                    }
                }
            } else if (classes != null && classes.length() > 0) {
                LogService.logMessage("Ignoring classes for non-nominal attribute " + label.getName() + ".", 4);
            }
        }
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        if (!this.getParameterAsBoolean("work_on_database")) {
            IOObject[] output = super.apply();
            this.disconnect();
            return output;
        }
        try {
            String tableName = this.getParameterAsString("table_name");
            if (tableName == null) {
                throw new UserError((Operator)this, 201, new Object[]{"table_name", "work_on_database", "true"});
            }
            DatabaseExampleTable table = DatabaseExampleTable.createDatabaseExampleTable(this.getConnectedDatabaseHandler(), tableName);
            ExampleSet exampleSet = this.createExampleSet(table);
            exampleSet.recalculateAllAttributeStatistics();
            return new IOObject[]{exampleSet};
        }
        catch (SQLException e) {
            throw new UserError((Operator)this, (Throwable)e, 304, (Object)e.getMessage());
        }
    }

    private String getQuery() throws OperatorException {
        String query = this.getParameterAsString("query");
        String parameterUsed = null;
        boolean warning = false;
        if (query == null) {
            File queryFile = this.getParameterAsFile("query_file");
            if (queryFile != null) {
                try {
                    query = Tools.readTextFile(queryFile);
                    parameterUsed = "query_file";
                }
                catch (IOException ioe) {
                    throw new UserError((Operator)this, (Throwable)ioe, 302, new Object[]{queryFile, ioe.getMessage()});
                }
                if (query.length() == 0) {
                    throw new UserError((Operator)this, 205, queryFile);
                }
            }
        } else {
            parameterUsed = "query";
            if (this.isParameterSet("query_file")) {
                warning = true;
            }
        }
        if (query == null) {
            if (this.isParameterSet("table_name")) {
                query = "select * from " + this.getParameterAsString("table_name");
                parameterUsed = "table_name";
            }
        } else if (this.isParameterSet("table_name")) {
            warning = true;
        }
        if (query == null) {
            throw new UserError((Operator)this, 202, new Object[]{"query", "query_file", "table_name"});
        }
        if (warning) {
            LogService.logMessage("Only one of the parameters 'query', 'query_file', and 'table_name' have to be set. Using value of '" + parameterUsed + "'.", 4);
        }
        return query;
    }

    private DatabaseHandler getConnectedDatabaseHandler() throws OperatorException, SQLException {
        String databaseURL = this.getParameterAsString("database_url");
        String username = this.getParameterAsString("username");
        String password = this.getParameterAsString("password");
        if (password == null) {
            password = Yale.getInputHandler().inputPassword("Password for user '" + username + "' required");
        }
        DatabaseHandler databaseHandler = new DatabaseHandler(databaseURL);
        LogService.logMessage("Connecting to '" + databaseURL + "'.", 0);
        databaseHandler.connect(username, password, true);
        return databaseHandler;
    }

    @Override
    public ResultSet getResultSet() throws OperatorException {
        ResultSet rs = null;
        try {
            this.dbAccess = this.getConnectedDatabaseHandler();
            String query = this.getQuery();
            LogService.logMessage("Executing query: '" + query + "'", 0);
            rs = this.dbAccess.query(query);
            LogService.logMessage("Query executed.", 0);
        }
        catch (SQLException sqle) {
            throw new UserError((Operator)this, (Throwable)sqle, 304, (Object)sqle.getMessage());
        }
        return rs;
    }

    @Override
    public void experimentFinished() {
        this.disconnect();
    }

    private void disconnect() {
        if (this.dbAccess != null) {
            try {
                this.dbAccess.disconnect();
                this.dbAccess = null;
            }
            catch (SQLException e) {
                LogService.logMessage("Cannot disconnect from database: " + e, 4);
            }
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeConfiguration type = new ParameterTypeConfiguration(DBExampleSourceConfigurationWizardCreator.class, this);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean("work_on_database", "(EXPERIMENTAL!) If set to true, the data read from the database is NOT copied to main memory. All operations that change data will modify the database.", false));
        types.add(new ParameterTypeString("database_url", "The complete URL connection string for the database, e.g. 'jdbc:mysql://foo.bar:portnr/database'", false));
        types.add(new ParameterTypeString("username", "Database username.", false));
        types.add(new ParameterTypePassword("password", "Password for the database."));
        types.add(new ParameterTypeText("query", "SQL query. If not set, the query is read from the file specified by 'query_file'.", TextType.SQL));
        types.add(new ParameterTypeFile("query_file", "File containing the query. Only evaluated if 'query' is not set.", null, true));
        types.add(new ParameterTypeString("table_name", "Use this table if work_on_database is true or no other query is specified."));
        types.add(new ParameterTypeString("classes", "Whitespace separated list of possible class values of the label attribute."));
        types.addAll(super.getParameterTypes());
        return types;
    }
}

