/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.tools.Tools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C45ExampleSource
extends Operator {
    public C45ExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        File file = this.getParameterAsFile("c45_filestem");
        File nameFile = this.getFile(file, "names");
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(nameFile));
        }
        catch (FileNotFoundException e) {
            throw new UserError((Operator)this, 301, nameFile);
        }
        Attribute label = AttributeFactory.createAttribute("label", 1);
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        try {
            String line = null;
            while ((line = in.readLine()) != null) {
                Object possibleValuesString;
                int valueType;
                int commentIndex = (line = line.trim()).indexOf("|");
                if (commentIndex >= 0) {
                    line = line.substring(0, commentIndex).trim();
                }
                if (line.length() > 0 && line.charAt(line.length() - 1) == '.') {
                    line = line.substring(0, line.length() - 1).trim();
                }
                if (line.length() == 0) continue;
                int colonIndex = line.indexOf(":");
                if (colonIndex >= 0) {
                    String attributeName = line.substring(0, colonIndex).trim();
                    String typeString = line.substring(colonIndex + 1).trim();
                    valueType = 1;
                    if (typeString.equals("continous")) {
                        valueType = 4;
                    }
                    Attribute attribute = AttributeFactory.createAttribute(attributeName, valueType);
                    if (valueType == 1 && !typeString.equals("discrete")) {
                        possibleValuesString = typeString;
                        String[] possibleValues = ((String)possibleValuesString).split(",");
                        String[] stringArray = possibleValues = Tools.mergeQuotedSplits((String)possibleValuesString, possibleValues, "\"");
                        int n = 0;
                        int n2 = stringArray.length;
                        while (n < n2) {
                            String s = stringArray[n];
                            attribute.getMapping().mapString(s.trim());
                            ++n;
                        }
                    }
                    attributes.add(attribute);
                    continue;
                }
                String[] possibleClasses = line.split(",");
                possibleClasses = Tools.mergeQuotedSplits(line, possibleClasses, "\"");
                possibleValuesString = possibleClasses;
                valueType = 0;
                int attribute = ((String[])possibleValuesString).length;
                while (valueType < attribute) {
                    String s = possibleValuesString[valueType];
                    label.getMapping().mapString(s.trim());
                    ++valueType;
                }
            }
            in.close();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 302, nameFile, (Object)e.getMessage());
        }
        attributes.add(label);
        File dataFile = this.getFile(file, "data");
        try {
            in = new BufferedReader(new FileReader(dataFile));
        }
        catch (FileNotFoundException e) {
            throw new UserError((Operator)this, 301, dataFile);
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        DataRowFactory factory = new DataRowFactory(this.getParameterAsInt("datamanagement"));
        Attribute[] attributeArray = new Attribute[attributes.size()];
        attributes.toArray(attributeArray);
        try {
            int lineCounter = 0;
            String line = null;
            while ((line = in.readLine()) != null) {
                ++lineCounter;
                int commentIndex = (line = line.trim()).indexOf("|");
                if (commentIndex >= 0) {
                    line = line.substring(0, commentIndex).trim();
                }
                if (line.length() > 0 && line.charAt(line.length() - 1) == '.') {
                    line = line.substring(0, line.length() - 1).trim();
                }
                if (line.length() == 0) continue;
                String[] tokens = line.split(",");
                if ((tokens = Tools.mergeQuotedSplits(line, tokens, "\"")).length != attributes.size()) {
                    in.close();
                    throw new UserError((Operator)this, 302, file, (Object)("Line " + lineCounter + ": the number of tokens in each line must be the same as the number of attributes (" + attributes.size() + "), was: " + tokens.length));
                }
                DataRow row = factory.create(tokens, attributeArray);
                table.addDataRow(row);
            }
            in.close();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 302, nameFile, (Object)e.getMessage());
        }
        return new IOObject[]{table.createExampleSet(label)};
    }

    private File getFile(File file, String extension) {
        String name = file.getName();
        String fileStem = null;
        fileStem = name.indexOf(46) < 0 ? name : name.substring(0, name.lastIndexOf(46));
        return new File(String.valueOf(file.getParent()) + File.separator + fileStem + "." + extension);
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("c45_filestem", "The path to either the C4.5 names file, the data file, or the filestem (without extensions). Both files must be in the same directory.", null, false));
        types.add(new ParameterTypeCategory("datamanagement", "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        return types;
    }
}

