/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeConstructionsWriter
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};

    public AttributeConstructionsWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        File generatorFile = this.getParameterAsFile("attribute_constructions_file");
        ExampleSet eSet = this.getInput(ExampleSet.class);
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new FileWriter(generatorFile));
                out.println("<constructions version=\"" + Yale.getVersion() + "\">");
                for (Attribute attribute : eSet.getAttributes()) {
                    out.println("    <attribute name=\"" + attribute.getName() + "\" construction=\"" + attribute.getConstruction().getDescription(false) + "\"/>");
                }
                out.println("</constructions>");
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, 303, new Object[]{generatorFile, e.getMessage()});
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return new IOObject[]{eSet};
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("attribute_constructions_file", "Filename for the attribute construction description file.", "att", false));
        return types;
    }
}

