/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.AttributeParser;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeConstructionsLoader
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};

    public AttributeConstructionsLoader(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.getInput(ExampleSet.class).clone();
        File file = this.getParameterAsFile("attribute_constructions_file");
        if (file != null) {
            try {
                AttributeParser parser = new AttributeParser(exampleSet.getExampleTable());
                FileInputStream in = new FileInputStream(file);
                parser.parseAll(in);
                ((InputStream)in).close();
                if (!this.getParameterAsBoolean("keep_all")) {
                    exampleSet.getAttributes().clearRegular();
                }
                parser.generateAll(exampleSet);
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, 302, new Object[]{file.getName(), e.getMessage()});
            }
        }
        return new IOObject[]{exampleSet};
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("attribute_constructions_file", "Filename for the attribute constructions file.", "att", false));
        types.add(new ParameterTypeBoolean("keep_all", "If set to true, all the original attributes are kept, otherwise they are removed from the example set.", false));
        return types;
    }
}

