/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.Tools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArffExampleSource
extends Operator {
    public ArffExampleSource(OperatorDescription description) {
        super(description);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IOObject[] apply() throws OperatorException {
        try {
            File file = this.getParameterAsFile("data_file");
            BufferedReader in = new BufferedReader(new FileReader(file));
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            Attribute label = null;
            Attribute weight = null;
            Attribute id = null;
            StreamTokenizer tokenizer = this.createTokenizer(in);
            Tools.getFirstToken(tokenizer);
            if (tokenizer.ttype == -1) {
                throw new UserError((Operator)this, 302, this.getParameterAsString("data_file"), (Object)"file is empty");
            }
            if (!"@relation".equalsIgnoreCase(tokenizer.sval)) {
                throw new IOException("expected the keyword @relation in line " + tokenizer.lineno());
            }
            Tools.getNextToken(tokenizer);
            Tools.getLastToken(tokenizer, false);
            Tools.getFirstToken(tokenizer);
            if (tokenizer.ttype == -1) {
                throw new IOException("unexpected end of file in line " + tokenizer.lineno() + ", attribute description expected...");
            }
            while (true) {
                if (!"@attribute".equalsIgnoreCase(tokenizer.sval)) {
                    if ("@data".equalsIgnoreCase(tokenizer.sval)) break;
                    throw new IOException("expected keyword '@data' in line " + tokenizer.lineno());
                }
                Attribute attribute = this.createAttribute(tokenizer);
                attributes.add(attribute);
                if (attribute.getName().equals(this.getParameterAsString("label_attribute"))) {
                    label = attribute;
                    continue;
                }
                if (attribute.getName().equals(this.getParameterAsString("id_attribute"))) {
                    id = attribute;
                    continue;
                }
                if (!attribute.getName().equals(this.getParameterAsString("weight_attribute"))) continue;
                weight = attribute;
            }
            if (attributes.size() == 0) {
                throw new IOException("no attributes were declared in the ARFF file, please declare attributes with the '@attribute' keyword.");
            }
            MemoryExampleTable table = new MemoryExampleTable(attributes);
            Attribute[] attributeArray = table.getAttributes();
            DataRowFactory factory = new DataRowFactory(this.getParameterAsInt("datamanagement"));
            DataRow dataRow = null;
            while (true) {
                if ((dataRow = this.createDataRow(tokenizer, true, factory, attributeArray)) == null) {
                    in.close();
                    HashMap<Attribute, String> specialMap = new HashMap<Attribute, String>();
                    specialMap.put(label, "label");
                    specialMap.put(weight, "weight");
                    specialMap.put(id, "id");
                    return new IOObject[]{table.createExampleSet(specialMap)};
                }
                table.addDataRow(dataRow);
            }
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 302, this.getParameterAsString("data_file"), (Object)e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    private Attribute createAttribute(StreamTokenizer tokenizer) throws IOException {
        block14: {
            block13: {
                attribute = null;
                Tools.getNextToken(tokenizer);
                attributeName = tokenizer.sval;
                Tools.getNextToken(tokenizer);
                if (tokenizer.ttype != -3) break block13;
                if (tokenizer.sval.equalsIgnoreCase("real")) {
                    attribute = AttributeFactory.createAttribute(attributeName, 4);
                } else if (tokenizer.sval.equalsIgnoreCase("integer")) {
                    attribute = AttributeFactory.createAttribute(attributeName, 3);
                } else if (tokenizer.sval.equalsIgnoreCase("numeric")) {
                    attribute = AttributeFactory.createAttribute(attributeName, 2);
                } else if (tokenizer.sval.equalsIgnoreCase("string")) {
                    attribute = AttributeFactory.createAttribute(attributeName, 5);
                } else if (tokenizer.sval.equalsIgnoreCase("date")) {
                    attribute = AttributeFactory.createAttribute(attributeName, 11);
                }
                Tools.waitForEOL(tokenizer);
                break block14;
            }
            attribute = AttributeFactory.createAttribute(attributeName, 1);
            tokenizer.pushBack();
            if (tokenizer.nextToken() == 123) ** GOTO lbl31
            throw new IOException("{ expected at beginning of nominal values definition in line " + tokenizer.lineno());
lbl-1000:
            // 1 sources

            {
                if (tokenizer.ttype == 10) {
                    throw new IOException("} expected at end of the nominal values definition in line " + tokenizer.lineno());
                }
                attribute.getMapping().mapString(tokenizer.sval);
lbl31:
                // 2 sources

                ** while (tokenizer.nextToken() != 125)
            }
lbl32:
            // 1 sources

            if (attribute.getMapping().size() == 0) {
                throw new IOException("empty definition of nominal values is not suggested in line " + tokenizer.lineno());
            }
        }
        Tools.getLastToken(tokenizer, false);
        Tools.getFirstToken(tokenizer);
        if (tokenizer.ttype == -1) {
            throw new IOException("unexpected end of file before data section in line " + tokenizer.lineno());
        }
        return attribute;
    }

    private DataRow createDataRow(StreamTokenizer tokenizer, boolean checkForCarriageReturn, DataRowFactory factory, Attribute[] allAttributes) throws IOException {
        Tools.getFirstToken(tokenizer);
        if (tokenizer.ttype == -1) {
            return null;
        }
        if (tokenizer.ttype == 123) {
            return this.createDataRowFromSparse(tokenizer, checkForCarriageReturn, factory, allAttributes);
        }
        return this.createDataRowFromDense(tokenizer, checkForCarriageReturn, factory, allAttributes);
    }

    private DataRow createDataRowFromDense(StreamTokenizer tokenizer, boolean checkForCarriageReturn, DataRowFactory factory, Attribute[] allAttributes) throws IOException {
        String[] tokens = new String[allAttributes.length];
        int i = 0;
        while (i < allAttributes.length) {
            if (i > 0) {
                Tools.getNextToken(tokenizer);
            }
            if (tokenizer.ttype == 63) {
                tokens[i] = "?";
            } else {
                if (tokenizer.ttype != -3) {
                    throw new IOException("not a valid value '" + tokenizer.sval + "' in line " + tokenizer.lineno());
                }
                tokens[i] = tokenizer.sval;
            }
            ++i;
        }
        if (checkForCarriageReturn) {
            Tools.getLastToken(tokenizer, true);
        }
        return factory.create(tokens, allAttributes);
    }

    private DataRow createDataRowFromSparse(StreamTokenizer tokenizer, boolean checkForCarriageReturn, DataRowFactory factory, Attribute[] allAttributes) throws IOException {
        String[] tokens = new String[allAttributes.length];
        int t = 0;
        while (t < tokens.length) {
            tokens[t] = "0";
            ++t;
        }
        while (true) {
            if (tokenizer.nextToken() == 10) {
                throw new IOException("unexpedted end of line " + tokenizer.lineno());
            }
            if (tokenizer.ttype == -1) {
                throw new IOException("unexpedted end of file in line " + tokenizer.lineno());
            }
            if (tokenizer.ttype == 125) break;
            int index = Integer.valueOf(tokenizer.sval);
            Tools.getNextToken(tokenizer);
            if (tokenizer.ttype == 63) {
                tokens[index] = "?";
                continue;
            }
            if (tokenizer.ttype != -3) {
                throw new IOException("not a valid value '" + tokenizer.sval + "' in line " + tokenizer.lineno());
            }
            tokens[index] = tokenizer.sval;
        }
        if (checkForCarriageReturn) {
            Tools.getLastToken(tokenizer, true);
        }
        return factory.create(tokens, allAttributes);
    }

    private StreamTokenizer createTokenizer(Reader in) {
        StreamTokenizer tokenizer = new StreamTokenizer(in);
        tokenizer.resetSyntax();
        tokenizer.whitespaceChars(0, 32);
        tokenizer.wordChars(33, 255);
        tokenizer.whitespaceChars(44, 44);
        tokenizer.commentChar(37);
        tokenizer.quoteChar(34);
        tokenizer.quoteChar(39);
        tokenizer.ordinaryChar(123);
        tokenizer.ordinaryChar(125);
        tokenizer.eolIsSignificant(true);
        return tokenizer;
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("data_file", "The path to the data file.", "arff", false));
        ParameterTypeString type = new ParameterTypeString("label_attribute", "The (case sensitive) name of the label attribute");
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString("id_attribute", "The (case sensitive) name of the id attribute"));
        types.add(new ParameterTypeString("weight_attribute", "The (case sensitive) name of the weight attribute"));
        types.add(new ParameterTypeCategory("datamanagement", "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        return types;
    }
}

