/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArffExampleSetWriter
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};

    public ArffExampleSetWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        try {
            File arffFile = this.getParameterAsFile("example_set_file");
            PrintWriter out = new PrintWriter(new FileWriter(arffFile));
            out.println("@RELATION YaleData");
            out.println();
            Iterator<Attribute> a = exampleSet.getAttributes().allAttributes();
            while (a.hasNext()) {
                this.printAttributeData(a.next(), out);
            }
            out.println();
            out.println("@DATA");
            for (Example example : exampleSet) {
                boolean first = true;
                a = exampleSet.getAttributes().allAttributes();
                while (a.hasNext()) {
                    Attribute current = a.next();
                    if (!first) {
                        out.print(",");
                    }
                    if (current.isNominal()) {
                        out.print("'" + example.getValueAsString(current) + "'");
                    } else {
                        out.print(example.getValueAsString(current));
                    }
                    first = false;
                }
                out.println();
            }
            out.close();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 303, new Object[]{this.getParameterAsString("example_set_file"), e.getMessage()});
        }
        return new IOObject[]{exampleSet};
    }

    private void printAttributeData(Attribute attribute, PrintWriter out) {
        out.print("@ATTRIBUTE '" + attribute.getName() + "' ");
        if (attribute.isNominal()) {
            StringBuffer nominalValues = new StringBuffer("{");
            boolean first = true;
            for (String s : attribute.getMapping().getValues()) {
                if (!first) {
                    nominalValues.append(",");
                }
                nominalValues.append("'" + s + "'");
                first = false;
            }
            nominalValues.append("}");
            out.print(nominalValues.toString());
        } else {
            out.print("real");
        }
        out.println();
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("example_set_file", "File to save the example set to.", "arff", false));
        return types;
    }
}

