/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.generator;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.operator.generator.TargetFunction;
import edu.udo.cs.yale.tools.RandomGenerator;

public class SpiralClusteringFunction
implements TargetFunction {
    private static final int NUMBER_OF_TURNS = 3;
    private static final double ANGLE_OFFSET = 4.71238898038469;
    private static final double ANGLE_FACTOR = Math.PI * 2;
    private static final double RADIUS_OFFSET = 2.0;
    private double bound = 10.0;
    private int totalNumber;
    private int currentNumber = 0;
    private double currentPhi = 0.0;
    private double deltaPhi;
    private double currentRadiusOffset = 0.0;
    private double currentLabel;
    Attribute label = AttributeFactory.createAttribute("label", 1);

    public SpiralClusteringFunction() {
        this.label.getMapping().mapString("spiral1");
        this.label.getMapping().mapString("spiral2");
    }

    public void init(RandomGenerator random) {
        this.currentPhi = 4.71238898038469;
        this.deltaPhi = 14.137166941154069 / ((double)this.totalNumber / 2.0);
        this.currentNumber = 0;
        this.currentRadiusOffset = 0.0;
        this.currentLabel = this.getLabel().getMapping().mapString("spiral1");
    }

    public void setTotalNumberOfExamples(int number) {
        this.totalNumber = number;
    }

    public void setTotalNumberOfAttributes(int number) {
    }

    public void setLowerArgumentBound(double lower) {
    }

    public void setUpperArgumentBound(double upper) {
    }

    public Attribute getLabel() {
        return this.label;
    }

    public double calculate(double[] att) throws TargetFunction.FunctionException {
        return this.currentLabel;
    }

    public double[] createArguments(int number, RandomGenerator random) throws TargetFunction.FunctionException {
        if (number != 2) {
            throw new TargetFunction.FunctionException("Ring clustering function", "must have 2 attributes!");
        }
        double[] args = new double[number];
        if (this.currentNumber == this.totalNumber / 2) {
            this.currentPhi = 4.71238898038469;
            this.currentRadiusOffset = 2.0;
            this.currentLabel = this.getLabel().getMapping().mapString("spiral2");
        }
        this.currentPhi += this.deltaPhi;
        double r = this.bound * this.currentPhi / 14.137166941154069 - this.currentRadiusOffset;
        args[0] = Math.cos(this.currentPhi) * r + random.nextGaussian() * 0.1;
        args[1] = Math.sin(this.currentPhi) * r + random.nextGaussian() * 0.1;
        ++this.currentNumber;
        return args;
    }
}

