/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.generator;

import edu.udo.cs.yale.operator.generator.ClassificationFunction;
import edu.udo.cs.yale.operator.generator.Dot;
import edu.udo.cs.yale.operator.generator.TargetFunction;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RandomDotsClassificationFunction
extends ClassificationFunction {
    private static final int NUMBER_OF_POSITIVE_DOTS = 10;
    private static final int NUMBER_OF_NEGATIVE_DOTS = 5;
    private List<Dot> positiveDots = new LinkedList<Dot>();
    private List<Dot> negativeDots = new LinkedList<Dot>();

    public void init(RandomGenerator random) {
        this.positiveDots.clear();
        this.negativeDots.clear();
        double maxRadius = (this.upper - this.lower) / 10.0;
        int i = 0;
        while (i < 10) {
            this.positiveDots.add(new Dot(random.nextDoubleInRange(this.lower, this.upper), random.nextDoubleInRange(this.lower, this.upper), random.nextDoubleInRange(0.0, maxRadius)));
            ++i;
        }
        i = 0;
        while (i < 5) {
            this.negativeDots.add(new Dot(random.nextDoubleInRange(this.lower, this.upper), random.nextDoubleInRange(this.lower, this.upper), random.nextDoubleInRange(0.0, maxRadius)));
            ++i;
        }
    }

    public double calculate(double[] att) throws TargetFunction.FunctionException {
        if (att.length != 2) {
            throw new TargetFunction.FunctionException("Random Dot classification function", "needs 2 attributes!");
        }
        for (Dot pDot : this.positiveDots) {
            if (!pDot.contains(att[0], att[1])) continue;
            Iterator<Dot> n = this.negativeDots.iterator();
            boolean negative = false;
            while (n.hasNext()) {
                Dot nDot = n.next();
                if (!nDot.contains(att[0], att[1])) continue;
                negative = true;
                break;
            }
            if (negative) {
                return this.getLabel().getMapping().mapString("negative");
            }
            return this.getLabel().getMapping().mapString("positive");
        }
        return this.getLabel().getMapping().mapString("negative");
    }
}

