/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.generator;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NominalExampleSetGenerator
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[0];
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};

    public NominalExampleSetGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt("number_examples");
        int numberOfAttributes = this.getParameterAsInt("number_of_attributes");
        int numberOfValues = this.getParameterAsInt("number_of_values");
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        int m = 0;
        while (m < numberOfAttributes) {
            Attribute current = AttributeFactory.createAttribute("att" + (m + 1), 1);
            int v = 0;
            while (v < numberOfValues) {
                current.getMapping().mapString("value" + v);
                ++v;
            }
            attributes.add(current);
            ++m;
        }
        Attribute label = AttributeFactory.createAttribute("label", 1);
        label.getMapping().mapString("negative");
        label.getMapping().mapString("positive");
        attributes.add(label);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt("local_random_seed"));
        int n = 0;
        while (n < numberOfExamples) {
            double[] features = new double[numberOfAttributes];
            int a = 0;
            while (a < features.length) {
                features[a] = random.nextIntInRange(0, numberOfValues - 1);
                ++a;
            }
            double[] example = features;
            if (label != null) {
                example = new double[numberOfAttributes + 1];
                System.arraycopy(features, 0, example, 0, features.length);
                example[example.length - 1] = features[0] == 0.0 || features[1] == 0.0 ? label.getMapping().mapString("positive") : label.getMapping().mapString("negative");
            }
            table.addDataRow(new DoubleArrayDataRow(example));
            ++n;
        }
        return new IOObject[]{table.createExampleSet(label)};
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("number_examples", "The number of generated examples.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("number_of_attributes", "The number of attributes.", 0, Integer.MAX_VALUE, 5);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("number_of_values", "The number of nominal values for each attribute.", 0, Integer.MAX_VALUE, 5);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt("local_random_seed", "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

