/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.generator;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleLabelGenerator
extends Operator {
    private static final int NUMBER_OF_ATTRIBUTES = 5;

    public MultipleLabelGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt("number_examples");
        double lower = this.getParameterAsDouble("attributes_lower_bound");
        double upper = this.getParameterAsDouble("attributes_upper_bound");
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        int m = 0;
        while (m < 5) {
            attributes.add(AttributeFactory.createAttribute("att" + (m + 1), 4));
            ++m;
        }
        int type = 1;
        if (this.getParameterAsBoolean("regression")) {
            type = 4;
        }
        Attribute label1 = AttributeFactory.createAttribute("label1", type);
        attributes.add(label1);
        Attribute label2 = AttributeFactory.createAttribute("label2", type);
        attributes.add(label2);
        Attribute label3 = AttributeFactory.createAttribute("label3", type);
        attributes.add(label3);
        if (!this.getParameterAsBoolean("regression")) {
            label1.getMapping().mapString("positive");
            label1.getMapping().mapString("negative");
            label2.getMapping().mapString("positive");
            label2.getMapping().mapString("negative");
            label3.getMapping().mapString("positive");
            label3.getMapping().mapString("negative");
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt("local_random_seed"));
        LinkedList<DoubleArrayDataRow> data = new LinkedList<DoubleArrayDataRow>();
        int n = 0;
        while (n < numberOfExamples) {
            double[] features = new double[5];
            int i = 0;
            while (i < features.length) {
                features[i] = random.nextDoubleInRange(lower, upper);
                ++i;
            }
            double[] example = new double[8];
            System.arraycopy(features, 0, example, 0, features.length);
            if (this.getParameterAsBoolean("regression")) {
                example[example.length - 3] = example[0] + example[1] + example[2];
                example[example.length - 2] = 2.0 * example[0] + example[3];
                example[example.length - 1] = example[3] * example[3];
            } else {
                example[example.length - 3] = example[0] + example[1] + example[2] > 0.0 ? label1.getMapping().mapString("positive") : label1.getMapping().mapString("negative");
                example[example.length - 2] = 2.0 * example[0] + example[3] > 0.0 ? label1.getMapping().mapString("positive") : label1.getMapping().mapString("negative");
                example[example.length - 1] = example[3] * example[3] - example[2] * example[2] > 0.0 ? label1.getMapping().mapString("positive") : label1.getMapping().mapString("negative");
            }
            data.add(new DoubleArrayDataRow(example));
            ++n;
        }
        table.readExamples(new ListDataRowReader(data.iterator()));
        HashMap<Attribute, String> specialMap = new HashMap<Attribute, String>();
        specialMap.put(label1, "label1");
        specialMap.put(label2, "label2");
        specialMap.put(label3, "label3");
        ExampleSet result = table.createExampleSet(specialMap);
        return new IOObject[]{result};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt("number_examples", "The number of generated examples.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean("regression", "Defines if multiple labels for regression tasks should be generated.", false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble("attributes_lower_bound", "The minimum value for the attributes.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, -10.0));
        types.add(new ParameterTypeDouble("attributes_upper_bound", "The maximum value for the attributes.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 10.0));
        types.add(new ParameterTypeInt("local_random_seed", "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

