/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.generator;

import edu.udo.cs.yale.example.AbstractSparseArrayDataRow;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.DoubleSparseArrayDataRow;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MassiveDataGenerator
extends Operator {
    public MassiveDataGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt("number_examples");
        int numberOfAttributes = this.getParameterAsInt("number_attributes");
        double sparseFraction = this.getParameterAsDouble("sparse_fraction");
        boolean sparseRepresentation = this.getParameterAsBoolean("sparse_representation");
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        int m = 0;
        while (m < numberOfAttributes) {
            attributes.add(AttributeFactory.createAttribute("att" + (m + 1), 4));
            ++m;
        }
        Attribute label = AttributeFactory.createAttribute("label", 1);
        label.getMapping().mapString("positive");
        label.getMapping().mapString("negative");
        attributes.add(label);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt("local_random_seed"));
        int n = 0;
        while (n < numberOfExamples) {
            double value;
            int i;
            Object dataRow;
            int counter = 0;
            if (sparseRepresentation) {
                dataRow = new DoubleSparseArrayDataRow(numberOfAttributes + 1);
                i = 0;
                while (i < numberOfAttributes) {
                    value = random.nextDouble() > sparseFraction ? 1.0 : 0.0;
                    ((DataRow)dataRow).set((Attribute)attributes.get(i), value);
                    if (value == 0.0) {
                        ++counter;
                    }
                    ++i;
                }
                if ((double)counter < sparseFraction * (double)numberOfAttributes) {
                    ((DataRow)dataRow).set(label, label.getMapping().mapString("positive"));
                } else {
                    ((DataRow)dataRow).set(label, label.getMapping().mapString("negative"));
                }
                ((AbstractSparseArrayDataRow)dataRow).trim();
                table.addDataRow((DataRow)dataRow);
            } else {
                dataRow = new double[numberOfAttributes + 1];
                i = 0;
                while (i < numberOfAttributes) {
                    dataRow[i] = value = random.nextDouble() > sparseFraction ? 1.0 : 0.0;
                    if (value == 0.0) {
                        ++counter;
                    }
                    ++i;
                }
                dataRow[((double[])dataRow).length - 1] = (double)counter < sparseFraction * (double)numberOfAttributes ? (Object)label.getMapping().mapString("positive") : (Object)label.getMapping().mapString("negative");
                table.addDataRow(new DoubleArrayDataRow((double[])dataRow));
            }
            ++n;
        }
        ExampleSet result = table.createExampleSet(label);
        return new IOObject[]{result};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("number_examples", "The number of generated examples.", 0, Integer.MAX_VALUE, 10000);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("number_attributes", "The number of attributes.", 0, Integer.MAX_VALUE, 10000);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble("sparse_fraction", "The fraction of default attributes.", 0.0, 1.0, 0.99));
        types.add(new ParameterTypeBoolean("sparse_representation", "Indicates if the example should be internally represented in a sparse format.", true));
        types.add(new ParameterTypeInt("local_random_seed", "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

