/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.generator;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.operator.generator.Cluster;
import edu.udo.cs.yale.operator.generator.TargetFunction;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.LinkedList;
import java.util.List;

public class GaussianMixtureFunction
implements TargetFunction {
    private static int CLUSTER_PER_DIMENSION = 2;
    private List<Cluster> clusters = new LinkedList<Cluster>();
    Attribute label = AttributeFactory.createAttribute("label", 1);
    private double currentLabel;
    private int numberOfAttributes = 2;
    private double lowerBound = -10.0;
    private double upperBound = 10.0;

    public void setLowerArgumentBound(double lower) {
        this.lowerBound = lower;
    }

    public void setUpperArgumentBound(double upper) {
        this.upperBound = upper;
    }

    public void init(RandomGenerator random) {
        this.clusters.clear();
        double sizeSum = 0.0;
        int numberOfClusters = (int)Math.pow(CLUSTER_PER_DIMENSION, this.numberOfAttributes);
        int i = 0;
        while (i < numberOfClusters) {
            double[] coordinates = new double[this.numberOfAttributes];
            double[] sigmas = new double[this.numberOfAttributes];
            int j = 0;
            while (j < coordinates.length) {
                coordinates[j] = random.nextDoubleInRange(this.lowerBound, this.upperBound);
                sigmas[j] = random.nextDouble() * 0.8 + 0.2;
                ++j;
            }
            int labelIndex = this.label.getMapping().mapString("cluster" + i);
            double size = random.nextDouble();
            sizeSum += size;
            this.clusters.add(new Cluster(coordinates, sigmas, size, labelIndex));
            ++i;
        }
        for (Cluster cluster : this.clusters) {
            cluster.size /= sizeSum;
        }
    }

    public void setTotalNumberOfExamples(int number) {
    }

    public void setTotalNumberOfAttributes(int number) {
        this.numberOfAttributes = number;
    }

    public Attribute getLabel() {
        return this.label;
    }

    public double calculate(double[] att) throws TargetFunction.FunctionException {
        return this.currentLabel;
    }

    public double[] createArguments(int number, RandomGenerator random) throws TargetFunction.FunctionException {
        if (number <= 0) {
            throw new TargetFunction.FunctionException("Gaussian mixture clustering function", "must have at least one attribute!");
        }
        int c = 0;
        double prob = random.nextDouble();
        double sizeSum = 0.0;
        Cluster cluster = null;
        do {
            cluster = this.clusters.get(c);
            if (prob < (sizeSum += cluster.size)) break;
            ++c;
        } while (sizeSum < 1.0);
        this.currentLabel = cluster.label;
        return cluster.createArguments(random);
    }
}

