/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.generator;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.generator.CheckerboardClassificationFunction;
import edu.udo.cs.yale.operator.generator.ComplicatedFunction;
import edu.udo.cs.yale.operator.generator.ComplicatedFunction2;
import edu.udo.cs.yale.operator.generator.GaussianFunction;
import edu.udo.cs.yale.operator.generator.GaussianMixtureFunction;
import edu.udo.cs.yale.operator.generator.GridFunction;
import edu.udo.cs.yale.operator.generator.InteractionClassificationFunction;
import edu.udo.cs.yale.operator.generator.MultiClassificationFunction;
import edu.udo.cs.yale.operator.generator.NonLinearFunction;
import edu.udo.cs.yale.operator.generator.OneThirdClassification;
import edu.udo.cs.yale.operator.generator.OneVariableNonLinearFunction;
import edu.udo.cs.yale.operator.generator.PolynomialClassificationFunction;
import edu.udo.cs.yale.operator.generator.PolynomialFunction;
import edu.udo.cs.yale.operator.generator.QuadraticClassificationFunction;
import edu.udo.cs.yale.operator.generator.RandomClassificationFunction;
import edu.udo.cs.yale.operator.generator.RandomDotsClassificationFunction;
import edu.udo.cs.yale.operator.generator.RandomFunction;
import edu.udo.cs.yale.operator.generator.RingClusteringFunction;
import edu.udo.cs.yale.operator.generator.SimpleNonLinearClassificationFunction;
import edu.udo.cs.yale.operator.generator.SimplePolynomialClassificationFunction;
import edu.udo.cs.yale.operator.generator.SimpleSinusFunction;
import edu.udo.cs.yale.operator.generator.SimpleSuperpositionFunction;
import edu.udo.cs.yale.operator.generator.SincFunction;
import edu.udo.cs.yale.operator.generator.SinusClassificationFunction;
import edu.udo.cs.yale.operator.generator.SinusFrequencyFunction;
import edu.udo.cs.yale.operator.generator.SinusFunction;
import edu.udo.cs.yale.operator.generator.SpiralClusteringFunction;
import edu.udo.cs.yale.operator.generator.SquarePulseFunction;
import edu.udo.cs.yale.operator.generator.SumClassificationFunction;
import edu.udo.cs.yale.operator.generator.SumFunction;
import edu.udo.cs.yale.operator.generator.TargetFunction;
import edu.udo.cs.yale.operator.generator.TransactionDatasetFunction;
import edu.udo.cs.yale.operator.generator.TriangularFunction;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import edu.udo.cs.yale.tools.RandomGenerator;
import edu.udo.cs.yale.tools.Tools;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleSetGenerator
extends Operator {
    private static final String[] KNOWN_FUNCTION_NAMES = new String[]{"random", "sum", "polynomial", "non linear", "one variable non linear", "complicated function", "complicated function2", "simple sinus", "sinus", "simple superposition", "sinus frequency", "sinc", "triangular function", "square pulse function", "random classification", "one third classification", "sum classification", "quadratic classification", "simple non linear classification", "interaction classification", "simple polynomial classification", "polynomial classification", "checkerboard classification", "random dots classification", "sinus classification", "multi classification", "transactions dataset", "grid function", "three ring clusters", "spiral cluster", "single gaussian cluster", "gaussian mixture clusters"};
    private static final Class[] KNOWN_FUNCTION_IMPLEMENTATIONS = new Class[]{RandomFunction.class, SumFunction.class, PolynomialFunction.class, NonLinearFunction.class, OneVariableNonLinearFunction.class, ComplicatedFunction.class, ComplicatedFunction2.class, SimpleSinusFunction.class, SinusFunction.class, SimpleSuperpositionFunction.class, SinusFrequencyFunction.class, SincFunction.class, TriangularFunction.class, SquarePulseFunction.class, RandomClassificationFunction.class, OneThirdClassification.class, SumClassificationFunction.class, QuadraticClassificationFunction.class, SimpleNonLinearClassificationFunction.class, InteractionClassificationFunction.class, SimplePolynomialClassificationFunction.class, PolynomialClassificationFunction.class, CheckerboardClassificationFunction.class, RandomDotsClassificationFunction.class, SinusClassificationFunction.class, MultiClassificationFunction.class, TransactionDatasetFunction.class, GridFunction.class, RingClusteringFunction.class, SpiralClusteringFunction.class, GaussianFunction.class, GaussianMixtureFunction.class};
    private static final Class[] INPUT_CLASSES = new Class[0];
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};

    public ExampleSetGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt("number_examples");
        int numberOfAttributes = this.getParameterAsInt("number_of_attributes");
        double lower = this.getParameterAsDouble("attributes_lower_bound");
        double upper = this.getParameterAsDouble("attributes_upper_bound");
        String functionName = this.getParameterAsString("target_function");
        if (functionName == null) {
            throw new UserError((Operator)this, 205, "target_function");
        }
        TargetFunction function = null;
        try {
            function = ExampleSetGenerator.getFunctionForName(functionName);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 904, new Object[]{functionName, e});
        }
        function.setLowerArgumentBound(lower);
        function.setUpperArgumentBound(upper);
        function.setTotalNumberOfExamples(numberOfExamples);
        function.setTotalNumberOfAttributes(numberOfAttributes);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        int m = 0;
        while (m < numberOfAttributes) {
            attributes.add(AttributeFactory.createAttribute("att" + (m + 1), 4));
            ++m;
        }
        Attribute label = function.getLabel();
        if (label != null) {
            attributes.add(label);
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt("local_random_seed"));
        LinkedList<DataRow> data = new LinkedList<DataRow>();
        DataRowFactory factory = new DataRowFactory(this.getParameterAsInt("datamanagement"), '.');
        try {
            function.init(random);
            int n = 0;
            while (n < numberOfExamples) {
                double[] features;
                double[] example = features = function.createArguments(numberOfAttributes, random);
                if (label != null) {
                    example = new double[numberOfAttributes + 1];
                    System.arraycopy(features, 0, example, 0, features.length);
                    example[example.length - 1] = function.calculate(features);
                }
                DataRow row = factory.create(example.length);
                int i = 0;
                while (i < example.length) {
                    row.set((Attribute)attributes.get(i), example[i]);
                    ++i;
                }
                data.add(row);
                ++n;
            }
        }
        catch (TargetFunction.FunctionException e) {
            throw new UserError((Operator)this, 918, e.getFunctionName(), (Object)e.getMessage());
        }
        table.readExamples(new ListDataRowReader(data.iterator()));
        ExampleSet result = table.createExampleSet(label);
        return new IOObject[]{result};
    }

    public static TargetFunction getFunctionForName(String functionName) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        int i = 0;
        while (i < KNOWN_FUNCTION_NAMES.length) {
            if (KNOWN_FUNCTION_NAMES[i].equals(functionName)) {
                return (TargetFunction)KNOWN_FUNCTION_IMPLEMENTATIONS[i].newInstance();
            }
            ++i;
        }
        Class clazz = Tools.classForName(functionName);
        return (TargetFunction)clazz.newInstance();
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeStringCategory("target_function", "Specifies the target function of this example set", KNOWN_FUNCTION_NAMES);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("number_examples", "The number of generated examples.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("number_of_attributes", "The number of attributes.", 1, Integer.MAX_VALUE, 5);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble("attributes_lower_bound", "The minimum value for the attributes.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, -10.0));
        types.add(new ParameterTypeDouble("attributes_upper_bound", "The maximum value for the attributes.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 10.0));
        types.add(new ParameterTypeInt("local_random_seed", "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeCategory("datamanagement", "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        return types;
    }
}

