/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.weighting;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.IndividualOperator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightingMutation
extends IndividualOperator {
    private double variance;
    private boolean bounded;
    private Random random;

    public WeightingMutation(double variance, boolean bounded, Random random) {
        this.variance = variance;
        this.bounded = bounded;
        this.random = random;
    }

    public void setVariance(double variance) {
        this.variance = variance;
    }

    public double getVariance() {
        return this.variance;
    }

    @Override
    public List<Individual> operate(Individual individual) {
        AttributeWeightedExampleSet exampleSet = individual.getExampleSet();
        LinkedList<Individual> l = new LinkedList<Individual>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            double weight = exampleSet.getWeight(attribute);
            weight += this.random.nextGaussian() * this.variance;
            if (this.bounded && (!(weight >= 0.0) || !(weight <= 1.0))) continue;
            exampleSet.setWeight(attribute, weight);
        }
        if (exampleSet.getNumberOfUsedAttributes() > 0) {
            l.add(new Individual(exampleSet));
        }
        return l;
    }
}

